
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL.h>
#include <SDL_video.h>

#define	_SDL
#define	_ASM_

#include "gbsdl.h"


int main(int argc, char* argv[])
{
	int index;
	u32 flags;

	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_TIMER)){
		printf("sdl init error.\n");
		exit(1);
	}

	if(argv[1]==NULL){
		/* t@C̎w肪Ȃ΃wv\*/
		printf(_TITLE" SDL version 0.06 for Linux <Build date "__DATE__">\n");
		printf("Copyright 2002 by Y_N <y_n@users.sourceforge.jp>\n");
		printf("Homepage: http://gameboyvm.cjb.net/\n");
		printf("Usage : GameboyVM [filename] [options]\n");
		printf("\t-F Full screen mode\n");
		printf("\t-V use hardware Video memory\n");
		printf("\t-A use hardware Accelation\n");
		printf("\t-P show frame Per seconds\n");
		printf("\t-S disable vertical Sync...\n");
		printf("\nNote: please do not use \"hardware Video memory\" and \"Full screen mode\" together.\n");
		exit(1);
	}
	
	index = 2;
	flags = SDL_SWSURFACE;
	for(index=2; argv[index]; index++){
		switch(argv[index][1]){
		case 'm':
		case 'M':
			flags=SDL_HWSURFACE;
			break;
		case 'f':
		case 'F':
			flags|=SDL_FULLSCREEN;
			break;
		case 'a':
		case 'A':
			flags|=SDL_HWACCEL;
			break;
		case 'p':
		case 'P':
			fFps=1;
			break;
		case 's':
		case 'S':
			fVsync=0;
			break;
		default:
			break;
		}
	}
	
	if(OpenRomFile(argv[1]))exit(0);
	if(InitializeVideo(flags))exit(0);
	InitializeMemory();
	InitializeRegister();
	
	ShowHeaderInfo();

	MainLoop();
	
	CloseROM();

	return 0;
}


int InitializeVideo(unsigned long flags)
{	/* T[tF[X̎擾ɎsꍇOȊOA*/
	int i;
	
	Surface = SDL_SetVideoMode(160, 144, 8, flags);
	if(Surface==NULL)return 1;
	SDL_WM_SetCaption(_TITLE, NULL);
	Surface->pixels = FrameBuffer;
	bmp_info = Surface->format;

	for(i=0; i<16; i++){
		colors[i].r =
		colors[i].g =
		colors[i].b = Colours[i%4];
	}
	
	SDL_SetColors(Surface, colors, 0, 16);

	return 0;
}


int OpenROM(char* filename)
{
	if(filename==NULL)return 1;
	fp = fopen(filename ,"rb");
	fread(ROM, 1, ROM_SIZE, fp);

	return 0;
}

void CloseROM() 
{
	CPUIsRunning=0;
	SDL_FreeSurface(Surface);
	if(fp!=NULL)fclose(fp);
	
	SDL_Quit();
}

_inline void DrawLCD()
{
	SDL_UpdateRect(Surface, 0, 0, 0, 0);
}

static void Keydown(SDL_keysym* Keysym)
{
	switch(Keysym->sym){
	case SDLK_RIGHT:	/*high-to-low*/
		keyflag&=~0x01;
		keyint=1;
		break;
	case SDLK_LEFT:
		keyflag&=~0x02;
		keyint=1;
		break;
	case SDLK_UP:
		keyflag&=~0x04;
		keyint=1;
		break;
	case SDLK_DOWN:
		keyflag&=~0x08;
		keyint=1;
		break;
	case SDLK_z:
		keyflag&=~0x10;
		keyint=1;
		break;
	case SDLK_x:
		keyflag&=~0x20;
		keyint=1;
		break;
	case SDLK_SPACE:
		keyflag&=~0x40;
		keyint=1;
		break;
	case SDLK_RETURN:
		keyflag&=~0x80;
		keyint=1;
		break;
	case SDLK_ESCAPE:
		CPUIsRunning=0;
	default:
		break;
	}
}

static void Keyup(SDL_keysym* Keysym)
{
	switch(Keysym->sym){
	case SDLK_RIGHT:	/*low-to-high*/
		keyflag|=0x01;
		keyint=2;
		break;
	case SDLK_LEFT:
		keyflag|=0x02;
		keyint=2;
		break;
	case SDLK_UP:
		keyflag|=0x04;
		keyint=2;
		break;
	case SDLK_DOWN:
		keyflag|=0x08;
		keyint=2;
		break;
	case SDLK_z:
		keyflag|=0x10;
		keyint=2;
		break;
	case SDLK_x:
		keyflag|=0x20;
		keyint=2;
		break;
	case SDLK_SPACE:
		keyflag|=0x40;
		keyint=2;
		break;
	case SDLK_RETURN:
		keyflag|=0x80;
		keyint=2;
		break;
	case SDLK_p:
		fFps=fFps?0:1;
		break;
	case SDLK_s:
		fVsync=fVsync?0:1;
		break;
	default:
		break;
	}
}

_inline void SDLEventLoop()
{
	SDL_PollEvent(&event);

	switch(event.type){
	case SDL_KEYDOWN:/*SDL_PRESSED*/
		Keydown(&event.key.keysym);
		break;
	case SDL_KEYUP:/*SDL_RELEASED*/
		Keyup(&event.key.keysym);
		break;
	case SDL_QUIT:
		exit(0);
		break;
	default:
		break;
	}
}


static void ShowFps()
{
	static char str[20];
	static unsigned long FpsTime;

	if(FpsTime < SDL_GetTicks()){
		FpsTime = SDL_GetTicks() + 1000;
		_itoa((int)((FrameCount)/59.0*100), str, 10);
		FrameCount = 0;
		SDL_WM_SetCaption(str, NULL);
	}
}

