

/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/



#ifndef	_DEFINES_
#define	_DEFINES_



#define	_TITLE		"GameboyVM"
#define	_VERSION	"0.05"

/*--------------------------------- vbgtH[̑I
#define	_WIN32_GDI
#define	_WIN32_SDL
#define	_WINCE_GDI
#define	_WIN_CMN
#define	_LINUX_SDL
#define	_SDL
#define	_ASM_
*/

/*--------------------------------- ^`*/
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef signed char s8;
typedef signed short s16;
typedef signed int s32;
typedef unsigned char byte;
typedef unsigned short hword;
typedef unsigned int word;

/*--------------------------------- CPUWX^`*/
typedef struct {
	u8	low;
	u8	high;
}REG8;

typedef union {
	REG8	reg8;
	u16		reg16;
}REGPAIR;

typedef struct{
	REGPAIR af;
	REGPAIR bc;
	REGPAIR de;
	REGPAIR	hl;
	u16	sp;
	REGPAIR	pc;
	u32	ime;
	u32	halt;
	u32	stop;
	u32	running;
}CPU_REGS;

CPU_REGS	cpu;

#define		A		af.reg8.high
#define		F		af.reg8.low
#define		B		bc.reg8.high
#define		C		bc.reg8.low
#define		D		de.reg8.high
#define		E		de.reg8.low
#define		H		hl.reg8.high
#define		L		hl.reg8.low
#define		PCH		pc.reg8.high
#define		PCL		pc.reg8.low

#define		AF		af.reg16
#define		BC		bc.reg16
#define		DE		de.reg16
#define		HL		hl.reg16
#define		SP		sp
#define		PC		pc.reg16

#define		CPUIsRunning	cpu.running

/*--------------------------------- tO̓ǂݏ}N*/
#define	_Z			0x80
#define _N			0x40
#define _H			0x20
#define _C			0x10
#define SF(_flag)	cpu.af.reg8.low|=(_flag)
#define RF(_flag)	cpu.af.reg8.low&=~(_flag)
#define FZ			((cpu.af.reg8.low)&0x80)
#define FN			((cpu.af.reg8.low)&0x40)
#define FH			((cpu.af.reg8.low)&0x20)
#define FC			((cpu.af.reg8.low)&0x10)
/*
#define LSB_FZ	(u8)(((cpu.af.reg8.low)>>7)&0x01)
#define LSB_FN	(u8)(((cpu.af.reg8.low)>>6)&0x01)
#define LSB_FH	(u8)(((cpu.af.reg8.low)>>5)&0x01)*/
#define LSB_FC	(u8)(((cpu.af.reg8.low)>>4)&0x01)
#define MSB_FC	(u8)(((cpu.af.reg8.low)<<3)&0x80)

/*--------------------------------- R[h̓ǂݎ*/
#define OPCODE	RMem((u16)(cpu.pc.reg16))
#define GETB	RMem((u16)((cpu.pc.reg16)+1))
#define GETW	RMem16((u16)((cpu.pc.reg16)+1))

/*--------------------------------- GBŗL̐l*/
#define	ROM_SIZE		0x80000
#define	S32_SIZE		0x8000
#define	BANK_SIZE		0x4000
#define MEM_SIZE		0x10000
#define GB_LCD_X		160
#define GB_LCD_Y		144

/*--------------------------------- IOWX^*/
#define R_P1	0xFF00
#define R_SB	0xFF01
#define R_SC	0xFF02
#define R_DIV	0xFF04
#define R_TIMA	0xFF05
#define R_TMA	0xFF06
#define R_TAC	0xFF07
#define R_IF	0xFF0F
#define R_NR10	0xFF10
#define R_NR11	0xFF11
#define R_NR12	0xFF12
#define R_NR13	0xFF13
#define R_NR14	0xFF14
#define R_NR21	0xFF16
#define R_NR22	0xFF17
#define R_NR23	0xFF18
#define R_NR24	0xFF19
#define R_NR30	0xFF1A
#define R_NR31	0xFF1B
#define R_NR32	0xFF1C
#define R_NR33	0xFF1D
#define R_NR34	0xFF1E
#define R_NR41	0xFF20
#define R_NR42	0xFF21
#define R_NR43	0xFF22
#define R_NR44	0xFF23
#define R_NR50	0xFF24
#define R_NR51	0xFF25
#define R_NR52	0xFF26
#define R_AUD3W	0xFF30
#define R_LCDC	0xFF40
#define R_STAT	0xFF41
#define R_SCY	0xFF42
#define R_SCX	0xFF43
#define R_LY	0xFF44
#define R_LYC	0xFF45
#define R_DMA	0xFF46
#define R_BGP	0xFF47
#define R_OBP0	0xFF48
#define R_OBP1	0xFF49
#define R_WY	0xFF4A
#define R_WX	0xFF4B
#define R_KEY1	0xFF4D
#define R_VBK	0xFF4F
#define R_HDMA1	0xFF51
#define R_HDMA2	0xFF52
#define R_HDMA3	0xFF53
#define R_HDMA4	0xFF54
#define R_HDMA5	0xFF55
#define R_RP	0xFF56
#define R_BCPS	0xFF68
#define R_BCPD	0xFF69
#define R_OCPS	0xFF6A
#define R_OCPD	0xFF6B
#define R_SVBK	0xFF70
#define R_IE	0xFFFF

/*--------------------------------- 荞*/
#define	IRQ_VBLANK	0
#define	IRQ_LCDC	1
#define	IRQ_TIMER	2
#define	IRQ_SERIAL	3
#define	IRQ_KEY		4

/*--------------------------------- XvCg֘A*/
#define	OBJ_Y	MEM[tma-2]	/*XvCgXW*/
#define	OBJ_X	MEM[tma-1]	/*XvCgYW*/
#define	OBJ_F	MEM[tma+1]	/*XvCg̃tO*/


#ifdef	_WINCE_GDI
#define	timeGetTime()	GetTickCount()
#endif	/*_WINCE*/

#ifdef	_WIN32
#define MSG(_msg_)	GBEmu.MessageBox(_msg_ ,NULL, NULL);
#endif	/*_WIN32*/

#ifdef	_SDL
#define	Sleep(_time_)	SDL_Delay(_time_)
#define	timeGetTime()	SDL_GetTicks()
typedef unsigned int	DWORD;
#endif	/*_SDL*/

#ifdef	_WIN32_LITE
#define	timeGetTime()	GetTickCount()
#endif	/*_WIN32_LITE*/



#endif	/*_DEFINES_*/



