// DispcntDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "DispcntDlg.h"

#include "../include/types.h"
#include "../include/gba.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern u32 RMem32(u32 adr);
extern BOOL fDispcntDlg;
extern DWORD dwSize;
LPBITMAPINFO disp_info;


/////////////////////////////////////////////////////////////////////////////
// CDispcntDlg _CAO


CDispcntDlg::CDispcntDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDispcntDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDispcntDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CDispcntDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDispcntDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDispcntDlg, CDialog)
	//{{AFX_MSG_MAP(CDispcntDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDispcntDlg bZ[W nh

void CDispcntDlg::OnOK()
{

}

void CDispcntDlg::OnCancel()
{
	OnClose();
}

BOOL CDispcntDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	disp_info = (LPBITMAPINFO)new char[dwSize];

	memset(disp_info, 0, sizeof(BITMAPINFOHEADER));
	disp_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	disp_info->bmiHeader.biWidth	= 240;
	disp_info->bmiHeader.biHeight	= -160;
	disp_info->bmiHeader.biPlanes	= 1;
	disp_info->bmiHeader.biBitCount	= 16;

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_DISPCNT_LCD), 0, 10, 10,
					240, 160, SWP_NOACTIVATE|SWP_NOZORDER);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDispcntDlg::ShowDispcnt()
{
	u32	dispcnt;
	CButton* pBPchk;

	dispcnt = RMem32(REG_DISPCNT);

	switch((u8)(dispcnt&7)){
	case 0:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE0);
		break;
	case 1:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE1);
		break;
	case 2:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE2);
		break;
	case 3:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE3);
		break;
	case 4:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE4);
		break;
	case 5:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE5);
		break;
	case 6:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE6);
		break;
	case 7:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE7);
		break;
	}

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG0);
	pBPchk->SetCheck((dispcnt & BG0_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG1);
	pBPchk->SetCheck((dispcnt & BG1_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG2);
	pBPchk->SetCheck((dispcnt & BG2_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG3);
	pBPchk->SetCheck((dispcnt & OBJ_ENABLE)?1:0);
	
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN0);
	pBPchk->SetCheck((dispcnt & WIN1_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN1);
	pBPchk->SetCheck((dispcnt & WIN2_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN2);
	pBPchk->SetCheck((dispcnt & WINOBJ_ENABLE)?1:0);
}

void CDispcntDlg::DrawDispcntLcd()
{
	u16 DispBuffer[240*160];

	CDC* pDC = GetDlgItem(IDC_DISPCNT_LCD)->GetDC();

	HDC	hMemDC	= ::CreateCompatibleDC(pDC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pDC->m_hDC, &disp_info->bmiHeader, CBM_INIT, DispBuffer, disp_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);
	::StretchBlt(pDC->m_hDC, 0, 0, 240, 160, hMemDC, 0, 0, 240, 160, SRCCOPY);
	::DeleteObject(hBitmap);
	
	ReleaseDC(pDC);
}

void CDispcntDlg::OnClose() 
{
	fDispcntDlg	= FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

BOOL CDispcntDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN==pMsg->message){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return FALSE;
		default:
			break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CDispcntDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	DrawDispcntLcd();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}
