// ChildView.cpp : CChildView NX̓̒`s܂B
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "ChildView.h"

#include "../include/defines.h"
#include "../include/filters.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef struct{
	BITMAPINFOHEADER	bmiHeader;
	RGBQUAD				bmiColors[256];
}BMPINFO;
BMPINFO bmp_info;

DWORD dwSize;
extern u32 RMem32(u32 adr);
extern u16 RMem16(u32 adr);
extern u8 VRam[0x18000];
extern u8 PalRam[0x400];
extern RECT clientSize;

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
	hDC = this->GetDC()->m_hDC;
	InitializeVideo(hDC);
	ReleaseDC(this->GetDC());

	hBitmap = NULL;
	dwSize = sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_MESSAGE(WM_DRAW_LCD, DrawLCD)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView bZ[W nh

void CChildView::InitializeVideo(HDC hDC)
{	/*rbg}bv*/
	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= LCD_X;
	bmp_info.bmiHeader.biHeight		= -LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 16;

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CChildView::DrawLCD()
{
	u32 i;
	u16	temp;

	/*mode 4 pbg*/
	if((RMem32(REG_DISPCNT) & 7) == MODE_4){
		for(i=0; i<(LCD_X * LCD_Y); i++){
			temp = PalRam[VRam[i]<<1] | (PalRam[(VRam[i]<<1)+1]<<8);
			temp = SWAP_RB(temp);
			pBitmap[i<<1] = (u8)temp;
			pBitmap[(i<<1)+1] = (u8)(temp>>8);
		}
	/*mode 3 rbg}bv*/
	}else /*if(RMem32(REG_DISPCNT)&MODE_3)*/{
		for(i=0; i<(LCD_X * LCD_Y * 2); i+=2){
			temp = VRam[i] | (VRam[i+1]<<8);
			temp = SWAP_RB(temp);	/*BGRRGB֕ϊ*/
			pBitmap[i] = (u8)temp;
			pBitmap[i+1] = (u8)(temp>>8);
		}
	}

/*	memcpy(pBitmap, FrameBuffer, LCD_X * LCD_Y);*/
	hDC = this->GetDC()->m_hDC;
	::StretchBlt(hDC, 0, 0, clientSize.right, clientSize.bottom, hMemDC,
					0, 0, LCD_X, LCD_Y, SRCCOPY);
	ReleaseDC(this->GetDC());
}

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.dwExStyle &= ~WS_EX_OVERLAPPEDWINDOW;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	DrawLCD();
}


