
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/
/* gba.h by eloist */

#ifndef GBA_HEADER
#define GBA_HEADER


#define REG_INTERUPT   0x3007FFC
#define REG_DISPCNT    0x4000000
#define REG_DISPCNT_L  0x4000000
#define REG_DISPCNT_H  0x4000002
#define REG_DISPSTAT   0x4000004
#define REG_VCOUNT     0x4000006
#define REG_BG0CNT     0x4000008
#define REG_BG1CNT     0x400000A
#define REG_BG2CNT     0x400000C
#define REG_BG3CNT     0x400000E
#define REG_BG0HOFS    0x4000010
#define REG_BG0VOFS    0x4000012
#define REG_BG1HOFS    0x4000014
#define REG_BG1VOFS    0x4000016
#define REG_BG2HOFS    0x4000018
#define REG_BG2VOFS    0x400001A
#define REG_BG3HOFS    0x400001C
#define REG_BG3VOFS    0x400001E
#define REG_BG2PA      0x4000020
#define REG_BG2PB      0x4000022
#define REG_BG2PC      0x4000024
#define REG_BG2PD      0x4000026
#define REG_BG2X       0x4000028
#define REG_BG2X_L     0x4000028
#define REG_BG2X_H     0x400002A
#define REG_BG2Y       0x400002C
#define REG_BG2Y_L     0x400002C
#define REG_BG2Y_H     0x400002E
#define REG_BG3PA      0x4000030
#define REG_BG3PB      0x4000032
#define REG_BG3PC      0x4000034
#define REG_BG3PD      0x4000036
#define REG_BG3X       0x4000038
#define REG_BG3X_L     0x4000038
#define REG_BG3X_H     0x400003A
#define REG_BG3Y       0x400003C
#define REG_BG3Y_L     0x400003C
#define REG_BG3Y_H     0x400003E
#define REG_WIN0H      0x4000040
#define REG_WIN1H      0x4000042
#define REG_WIN0V      0x4000044
#define REG_WIN1V      0x4000046
#define REG_WININ      0x4000048
#define REG_WINOUT     0x400004A
#define REG_MOSAIC     0x400004C
#define REG_MOSAIC_L   0x400004C
#define REG_MOSAIC_H   0x400004E
#define REG_BLDMOD     0x4000050
#define REG_COLEV      0x4000052
#define REG_COLEY      0x4000054
#define REG_SG10       0x4000060
#define REG_SG10_L     0x4000060
#define REG_SG10_H     0x4000062
#define REG_SG11       0x4000064
#define REG_SG20       0x4000068
#define REG_SG21       0x400006C
#define REG_SG30       0x4000070
#define REG_SG30_L     0x4000070
#define REG_SG30_H     0x4000072
#define REG_SG31       0x4000074
#define REG_SG40       0x4000078
#define REG_SG41       0x400007C
#define REG_SGCNT0     0x4000080
#define REG_SGCNT0_L   0x4000080
#define REG_SGCNT0_H   0x4000082
#define REG_SGCNT1     0x4000084
#define REG_SGBIAS     0x4000088
#define REG_SGWR0      0x4000090
#define REG_SGWR0_L    0x4000090
#define REG_SGWR0_H    0x4000092
#define REG_SGWR1      0x4000094
#define REG_SGWR1_L    0x4000094
#define REG_SGWR1_H    0x4000096
#define REG_SGWR2      0x4000098
#define REG_SGWR2_L    0x4000098
#define REG_SGWR2_H    0x400009A
#define REG_SGWR3      0x400009C
#define REG_SGWR3_L    0x400009C
#define REG_SGWR3_H    0x400009E
#define REG_SGFIF0A    0x40000A0
#define REG_SGFIFOA_L  0x40000A0
#define REG_SGFIFOA_H  0x40000A2
#define REG_SGFIFOB    0x40000A4
#define REG_SGFIFOB_L  0x40000A4
#define REG_SGFIFOB_H  0x40000A6
#define REG_DM0SAD     0x40000B0
#define REG_DM0SAD_L   0x40000B0
#define REG_DM0SAD_H   0x40000B2
#define REG_DM0DAD     0x40000B4
#define REG_DM0DAD_L   0x40000B4
#define REG_DM0DAD_H   0x40000B6
#define REG_DM0CNT     0x40000B8
#define REG_DM0CNT_L   0x40000B8
#define REG_DM0CNT_H   0x40000BA
#define REG_DM1SAD     0x40000BC
#define REG_DM1SAD_L   0x40000BC
#define REG_DM1SAD_H   0x40000BE
#define REG_DM1DAD     0x40000C0
#define REG_DM1DAD_L   0x40000C0
#define REG_DM1DAD_H   0x40000C2
#define REG_DM1CNT     0x40000C4
#define REG_DM1CNT_L   0x40000C4
#define REG_DM1CNT_H   0x40000C6
#define REG_DM2SAD     0x40000C8
#define REG_DM2SAD_L   0x40000C8
#define REG_DM2SAD_H   0x40000CA
#define REG_DM2DAD     0x40000CC
#define REG_DM2DAD_L   0x40000CC
#define REG_DM2DAD_H   0x40000CE
#define REG_DM2CNT     0x40000D0
#define REG_DM2CNT_L   0x40000D0
#define REG_DM2CNT_H   0x40000D2
#define REG_DM3SAD     0x40000D4
#define REG_DM3SAD_L   0x40000D4
#define REG_DM3SAD_H   0x40000D6
#define REG_DM3DAD     0x40000D8
#define REG_DM3DAD_L   0x40000D8
#define REG_DM3DAD_H   0x40000DA
#define REG_DM3CNT     0x40000DC
#define REG_DM3CNT_L   0x40000DC
#define REG_DM3CNT_H   0x40000DE
#define REG_TM0D       0x4000100
#define REG_TM0CNT     0x4000102
#define REG_TM1D       0x4000104
#define REG_TM1CNT     0x4000106
#define REG_TM2D       0x4000108
#define REG_TM2CNT     0x400010A
#define REG_TM3D       0x400010C
#define REG_TM3CNT     0x400010E
#define REG_SCD0       0x4000120
#define REG_SCD1       0x4000122
#define REG_SCD2       0x4000124
#define REG_SCD3       0x4000126
#define REG_SCCNT      0x4000128
#define REG_SCCNT_L    0x4000128
#define REG_SCCNT_H    0x400012A
#define REG_P1         0x4000130
#define REG_P1CNT      0x4000132
#define REG_R          0x4000134
#define REG_HS_CTRL    0x4000140
#define REG_JOYRE      0x4000150
#define REG_JOYRE_L    0x4000150
#define REG_JOYRE_H    0x4000152
#define REG_JOYTR      0x4000154
#define REG_JOYTR_L    0x4000154
#define REG_JOYTR_H    0x4000156
#define REG_JSTAT      0x4000158
#define REG_JSTAT_L    0x4000158
#define REG_JSTAT_H    0x400015A
#define REG_IE         0x4000200
#define REG_IF         0x4000202
#define REG_WSCNT      0x4000204
#define REG_IME        0x4000208
#define REG_PAUSE      0x4000300





///// REG_DISPCNT defines

#define MODE_0 0x0
#define MODE_1 0x1
#define MODE_2 0x2
#define MODE_3 0x3
#define MODE_4 0x4
#define MODE_5 0x5

#define BACKBUFFER 0x10
#define H_BLANK_OAM 0x20 

#define OBJ_MAP_2D 0x0
#define OBJ_MAP_1D 0x40

#define FORCE_BLANK 0x80

#define BG0_ENABLE 0x100
#define BG1_ENABLE 0x200
#define BG2_ENABLE 0x400
#define BG3_ENABLE 0x800
#define OBJ_ENABLE 0x1000 

#define WIN1_ENABLE 0x2000 
#define WIN2_ENABLE 0x4000
#define WINOBJ_ENABLE 0x8000





#define KEY_A 		1
#define KEY_B 		2
#define KEY_SELECT	4
#define KEY_START 	8
#define KEY_RIGHT 	16
#define KEY_LEFT 		32
#define KEY_UP 		64
#define KEY_DOWN 		128
#define KEY_R		256
#define KEY_L 		512


#define BIT0	1
#define BIT1	2
#define BIT2	4
#define BIT3	8
#define BIT4	16
#define BIT5	32
#define BIT6	64
#define BIT7	128
#define BIT8	256
#define BIT9	512
#define BIT10	1024
#define BIT11	2048
#define BIT12	4096
#define BIT13	8192
#define BIT14	16384
#define BIT15	32768

#define	SCREEN_X	240
#define	SCREEN_Y	160

/*
#define RGB32(r,g,b)	((((b)>>3)<<10)+(((g)>>3)<<5)+((r)>>3))
#define RGB(r,g,b)		(u16)(r+(g<<5)+(b<<10))
*/

#endif



