
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


void InitializeMemory()
{
//	int i;

	memset(VRam, 0, 0x18000);
/*	
	for(i=0; i<0x400; i++){
		PaletteRam[i] = i;
	}
*/
}

u8 RMem8(u32 adr)
{
	if(0x00000000<=adr && adr<0x00004000)return SystemRom[adr];
	if(0x02000000<=adr && adr<0x02040000)return ExWorkRam[adr-0x02000000];
	if(0x03000000<=adr && adr<0x03080000)return InWorkRam[adr-0x03000000];
	if(0x04000000<=adr && adr<0x04000400){
		if(REG_P1==adr)return (u8)keyflag;
		if((REG_P1+1)==adr)return (u8)(keyflag>>8);
		return IoRam[adr-0x04000000];
	}
	if(0x05000000<=adr && adr<0x05000400)return PalRam[adr-0x05000000];
	if(0x06000000<=adr && adr<0x06018000)return VRam[adr-0x06000000];
	if(0x07000000<=adr && adr<0x07000400)return Oam[adr-0x07000000];
	if(0x08000000<=adr && adr<(0x08000000+filesize))return Rom[adr-0x08000000];

	return 0;
}

u16 RMem16(u32 adr)
{
	if(0x00000000<=adr && adr<0x00004000)
	{
		return SystemRom[adr]|(SystemRom[adr+1]<<8);
	}
	if(0x02000000<=adr && adr<0x02040000)
	{
		adr -= 0x02000000;
		return ExWorkRam[adr]|(ExWorkRam[adr+1]<<8);
	}
	if(0x03000000<=adr && adr<0x03080000)
	{
		adr -= 0x03000000;
		return InWorkRam[adr]|(InWorkRam[adr+1]<<8);
	}
	if(0x04000000<=adr && adr<0x04000400)
	{
		if(REG_P1==adr)return keyflag;
		if((REG_P1+1)==adr)return (keyflag>>8);
		adr -= 0x04000000;
		return (u16)(IoRam[adr]|(IoRam[adr+1]<<8));
	}
	if(0x05000000<=adr && adr<0x05000400)
	{
		adr -= 0x05000000;
		return PalRam[adr]|(PalRam[adr+1]<<8);
	}
	if(0x06000000<=adr && adr<0x06018000)
	{
		adr -= 0x06000000;
		return VRam[adr]|(VRam[adr+1]<<8);
	}
	if(0x07000000<=adr && adr<0x07000400)
	{
		adr -= 0x07000000;
		return Oam[adr]|(Oam[adr+1]<<8);
	}
	if(0x08000000<=adr && adr<(0x08000000+filesize)){
		adr -= 0x08000000;
		return Rom[adr]|(Rom[adr+1]<<8);
	}

	return 0;
}

u32 RMem32(u32 adr)
{
	if(0x00000000<=adr && adr<0x00004000){
		return (u32)(SystemRom[adr]|(SystemRom[adr+1]<<8)|(SystemRom[adr+2]<<16)|(SystemRom[adr+3]<<24));
	}
	if(0x02000000<=adr && adr<0x02040000){
		adr -= 0x02000000;
		return (u32)(ExWorkRam[adr]|(ExWorkRam[adr+1]<<8)|(ExWorkRam[adr+2]<<16)|(ExWorkRam[adr+3]<<24));
	}
	if(0x03000000<=adr && adr<0x03080000){
		adr -= 0x03000000;
		return (u32)(InWorkRam[adr]|(InWorkRam[adr+1]<<8)|(InWorkRam[adr+2]<<16)|(InWorkRam[adr+3]<<24));
	}
	if(0x04000000<=adr && adr<0x04000400){
		if(REG_P1==adr)return keyflag;
		if((REG_P1+1)==adr)return (keyflag>>8);
		adr -= 0x04000000;
		return (u32)(IoRam[adr]|(IoRam[adr+1]<<8)|(IoRam[adr+2]<<16)|(IoRam[adr+3]<<24));
	}
	if(0x05000000<=adr && adr<0x05000400){
		adr -= 0x05000000;
		return (u32)(PalRam[adr]|(PalRam[adr+1]<<8)|(PalRam[adr+2]<<16)|(PalRam[adr+3]<<24));
	}
	if(0x06000000<=adr && adr<0x06018000){
		adr -= 0x06000000;
		return (u32)(VRam[adr]|(VRam[adr+1]<<8)|(VRam[adr+2]<<16)|(VRam[adr+3]<<24));
	}
	if(0x07000000<=adr && adr<0x07000400){
		adr -= 0x07000000;
		return (u32)(Oam[adr]|(Oam[adr+1]<<8)|(Oam[adr+2]<<16)|(Oam[adr+3]<<24));
	}
	if(0x08000000<=adr && adr<(0x08000000+filesize)){
		adr -= 0x08000000;
		return (u32)(Rom[adr]|(Rom[adr+1]<<8)|(Rom[adr+2]<<16)|(Rom[adr+3]<<24));
	}

	return 0;
}

_inline int WMem8(u32 adr, u8 val)
{
	if(0x02000000<=adr && adr<0x02040000){
		ExWorkRam[adr - 0x02000000]	= val;
		return 0;
	}
	if(0x03000000<=adr && adr<0x03080000){
		InWorkRam[adr - 0x03000000]	= val;
		return 0;
	}
	if(0x04000000<=adr && adr<0x04000400){
		IoRam[adr - 0x04000000]		= val;
		return 0;
	}
	if(0x05000000<=adr && adr<0x05000400){
		PalRam[adr - 0x05000000]		= val;
		return 0;
	}
	if(0x06000000<=adr && adr<0x06018000){
		VRam[adr - 0x06000000]		= val;
		return 0;
	}
	if(0x07000000<=adr && adr<0x07000400){
		Oam[adr - 0x07000000]		= val;
		return 0;
	}

	return 1;
}

_inline int WMem16(u32 adr, u16 val)
{
	u8	*pMem;

	if(0x02000000<=adr && adr<0x02040000)
	{
		pMem	= &ExWorkRam[adr - 0x02000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x03000000<=adr && adr<0x03080000)
	{
		pMem	= &InWorkRam[adr - 0x03000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x04000000<=adr && adr<0x04000400)
	{
		pMem	= &IoRam[adr - 0x04000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x05000000<=adr && adr<0x05000400)
	{
		pMem	= &PalRam[adr - 0x05000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x06000000<=adr && adr<0x06018000)
	{
		pMem	= &VRam[adr - 0x06000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}
	if(0x07000000<=adr && adr<0x07000400)
	{
		pMem	= &Oam[adr - 0x07000000];
		*pMem	= (u8)val;
		pMem++;
		*pMem	= (u8)(val>>8);
		return 0;
	}

	return 1;
}

_inline int WMem32(u32 adr, u32 val)
{
	u32	count, sadr, dadr, size;
	u8	*pMem;
#ifdef	_LENDIAN_
		u32 *pmem32;
#endif

	if(0x02000000<=adr && adr<0x02040000){
		pMem  = &ExWorkRam[adr - 0x02000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x03000000<=adr && adr<0x03080000){
		pMem = &InWorkRam[adr - 0x03000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x04000000<=adr && adr<0x04000400){
		if(adr==REG_DM0CNT){	/*DMA0*/
			size = 0x3FFF & val;
			sadr = 0x07FFFFFF & RMem32(REG_DM0SAD);	/*], 0ROM̈włȂ*/
			dadr = 0x07FFFFFF & RMem32(REG_DM0DAD);	/*]*/
			TRACE("dma0 dst=%08X, src=%08X, size=%08X", sadr, dadr, size);
			if(val & BIT_24_){	/*ZtO*/
				for(count=val; count>size; count-=4){
					WMem32(dadr, RMem32(sadr));
					sadr -= 4;
					dadr -= 4;
				}
			}else{
				for(count=0; count<size; count+=4){
					WMem32(dadr, RMem32(sadr));
					sadr += 4;
					dadr += 4;
				}
			}
		}
		if(adr==REG_DM1CNT){	/*DMA1*/
			sadr = 0x0FFFFFFF & RMem32(REG_DM1SAD);	/*]*/
			dadr = 0x07FFFFFF & RMem32(REG_DM1DAD);	/*]*/
			TRACE("dma1 dst=%08X, src=%08X, size=%08X", sadr, dadr, size);
			if(val & BIT_24_){	/*ZtO*/
				for(count=val; count>val; count-=4){
					WMem32(dadr, RMem32(sadr));
					sadr -= 4;
					dadr -= 4;
				}
			}else{
				for(count=0; count<val; count+=4){
					WMem32(dadr, RMem32(sadr));
					sadr += 4;
					dadr += 4;
				}
			}
		}
		if(adr==REG_DM2CNT){	/*DMA2*/
			sadr = 0x0FFFFFFF & RMem32(REG_DM2SAD);	/*]*/
			dadr = 0x07FFFFFF & RMem32(REG_DM2DAD);	/*]*/
			TRACE("dma2 dst=%08X, src=%08X, size=%08X", sadr, dadr, size);
			if(val & BIT_24_){	/*ZtO*/
				for(count=val; count>val; count-=4){
					WMem32(dadr, RMem32(sadr));
					sadr -= 4;
					dadr -= 4;
				}
			}else{
				for(count=0; count<val; count+=4){
					WMem32(dadr, RMem32(sadr));
					sadr += 4;
					dadr += 4;
				}
			}
		}
		if(adr==REG_DM3CNT){	/*DMA3 ]*/
			sadr = 0x0FFFFFFF & RMem32(REG_DM3SAD);	/*]*/
			dadr = 0x0FFFFFFF & RMem32(REG_DM3DAD);	/*], (ROM̈ȉwł)*/
			TRACE("dma3 dst=%08X, src=%08X, size=%08X", sadr, dadr, size);
			if(val & BIT_24_){	/*ZtO*/
				for(count=val; count>val; count-=4){
					WMem32(dadr, RMem32(sadr));
					sadr -= 4;
					dadr -= 4;
				}
			}else{
				for(count=0; count<val; count+=4){
					WMem32(dadr, RMem32(sadr));
					sadr += 4;
					dadr += 4;
				}
			}
		}
		pMem = &IoRam[adr - 0x04000000];
#ifdef	_LENDIAN_
		pmem32 = (u32*)pMem;
		*pmem32 = val;
#else
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
#endif	/*_LENDIAN_*/
		return 0;
	}
	if(0x05000000<=adr && adr<0x05000400){
		pMem = &PalRam[adr - 0x05000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x06000000<=adr && adr<0x06018000){
		pMem = &VRam[adr - 0x06000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}
	if(0x07000000<=adr && adr<0x07000400){
		pMem = &Oam[adr - 0x07000000];
		*pMem = (u8)val;
		pMem++;
		*pMem = (u8)(val>>8);
		pMem++;
		*pMem = (u8)(val>>16);
		pMem++;
		*pMem = (u8)(val>>24);
		return 0;
	}

	return 1;
}


