
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


_inline void agb_timer(u32 clk)
{
	static const u32 Timer_table[]={1, 64, 256, 1024};
	static u32 tm0, tm1, tm2, tm3;
	u32 countup;	/*I[o[t[JE^*/
	u32 ttr;		/*^C}[WX^ꎞۑ*/

	countup = 0;

	ttr = IoRam[0x102];
	if(ttr&0x80){	/*TM0_CNT ^C}[ғtO*/
		if((Timer_table[(ttr&0x03)]-tm0)<=0){	/*JE^*/
			WMem16(0x04000100, RMem16(0x04000100)+1);
			tm0-=Timer_table[(ttr&0x03)];
			countup++;
		}
	}
	
	ttr = IoRam[0x106];
	if(ttr&0x80){	/*TM1_CNT ^C}[ғtO*/
		if((Timer_table[(ttr&0x03)]-tm1)<=0){
			WMem16(0x04000104, RMem16(0x04000104)+1);
			tm1-=Timer_table[(ttr&0x03)];
			countup++;
			/*Ⴂԍ(TM0)̃JE^I[o[t[ꍇɑ*/
			if(ttr&0x04)WMem16(0x04000104, RMem16(0x04000104)+1);
		}
	}

	ttr = IoRam[0x10A];
	if(ttr&0x80){	/*TM2_CNT ^C}[ғtO*/
		if((Timer_table[(ttr&0x03)]-tm2)<=0){
			WMem16(0x04000108, RMem16(0x04000108)+1);
			tm2-=Timer_table[(ttr&0x03)];
			countup++;
			/*Ⴂԍ(TM0,TM1)̃JE^I[o[t[ꍇɑ*/
			if(ttr&0x04)WMem16(0x04000108, RMem16(0x04000108)+1);
		}
	}

	ttr = IoRam[0x10E];
	if(ttr&0x80){	/*TM3_CNT ^C}[ғtO*/
		if((Timer_table[(ttr&0x03)]-tm3)<=0){
			WMem16(0x0400010C, RMem16(0x0400010C)+1);
			tm3-=Timer_table[(ttr&0x03)];
			countup++;
			/*Ⴂԍ(TM0, TM1, TM2)̃JE^I[o[t[ꍇɑ*/
			if(ttr&0x04)WMem16(0x0400010C, RMem16(0x0400010C)+1);
		}
	}

}

void CMainFrame::Mainloop()
{
	DWORD WaitTime = timeGetTime() + 17;

	fTMain = TRUE;

	WMem8(0x04000006, 0xA0);/*ɐA*/

	do{
		if(CPSR & T_){
			exec_thumb_state();
		}else{
			exec_arm_state();
		}
		
		if(fBreak){	/*u[N|Cg*/
			if(BreakPoint1==PC || BreakPoint2==PC || BreakPoint3==PC || BreakPoint4==PC){
				CPUIsRunning = FALSE;
			}
		}

		agb_timer(arm.cycle);

		htime -= arm.cycle;

		if(htime <= 228){	/*A*/
			IoRam[0x004] |= 0x02;			
		}else{
			IoRam[0x004] &= ~0x02;
		}

		if(htime<=0){	/* (16.78MHz/59.73)/228line */
			htime += 1232;
			//DrawLine();
		}

		vtime -= cycle;
		if(htime <= 83410){	/*A*/
			IoRam[0x004] |= 0x01;
		}else{
			IoRam[0x004] &= ~0x01;		
		}
		if(vtime <= 0){	/* 16.78MHz/59.73  */
			vtime += 280896;
			m_wndView.DrawLCD();	/* 229-160=68(VBlank) */
			FrameCount++;
			if(fAutoUpdate){
				UpdateDebugger();
			}
			while(WaitTime > timeGetTime() && fVsync){Sleep(1);};
			WaitTime = timeGetTime() + 17;
		}
	}while(CPUIsRunning);
	fTMain = FALSE;

	m_wndView.DrawLCD();
}

