;;------------------------------------------------------------
;;	mode4 drawretc demo
;;
;;	note : r13=sp, r14=lr, r15=pc, r16=cpsr
;;------------------------------------------------------------

@arm
@fsize	32
	b		agb_main

@dup	dcb 0xba, 0x00			; vOwb_[̈

agb_main:
	mov		r0, #0x4000000
	mov		r1, #0x400
	add		r1, r1, #0x4
	str		r1, [r0]			; mode4ɐݒ

;	bl	wait_vbk				; A҂

	mov		r0, #1
	mov		r1, #0xFF
	add		r1, r1, #0x7F00		; F
	stm		sp!, {r0-r1}
	bl		SetPalette

	mov		r2, #1
	mov		r3, #60
	mov		r4, #20
	mov		r5, #50
	mov		r6, #50				; W
	stm		sp!, {r2-r6}
	bl		DrawRect

;;------------------------------------------------------------
;;	[v
;;	
;;------------------------------------------------------------
forever:
	b		forever

;;------------------------------------------------------------
;;	A҂
;;	
;;------------------------------------------------------------
wait_vbk:
	mov		r0, #0x06
	add		r0, r0, #0x04000000
	ldr		r1, [r0]
	mov		r2, #160
	cmp		r1, r2
	bhi		wait_vbk

	mov		pc, r14
	movs	pc, r14				; return


;;------------------------------------------------------------
;;	pbg̐ݒ
;;	SetPalette(u8 index, u16 color)
;;------------------------------------------------------------

SetPalette:
	ldm		sp!, {r0-r1}
	mov		r12, #0x05000000	; palette ram address

	and		r0, r0, #0xFF		; CfbNXoCg^ɃLXg
	mov		r0, r0, lsl#1		; index *= 2
	strh	r1, [r12, r0]

	mov		pc, r14
	movs	pc, r14				; return


;;------------------------------------------------------------
;;	lp`̕`
;;	DrawRect(color, x, y, width, height)
;;------------------------------------------------------------

DrawRect:
	ldm		sp!, {r3-r7}
	mov		r12, #0x06000000	; vram address

	add		r8, r4, r6
	add		r9, r5, r7

	mov		r11, r5

for_rect_y:
	mov		r10, r4

for_rect_x:
	mov		r2, #240
	mul		r2, r11, r2
	add		r2, r2, r10			; r10 + r11 * 240
;	mov		r2, r2, lsl#1		; r2 *= 2;
	strb	r3, [r12, r2]

	add		r10, r10, #1
	cmp		r8, r10				; r10<r8
	bhi		for_rect_x

	add		r11, r11, #1
	cmp		r9, r11				; r11<r9
	bhi		for_rect_y

	mov		pc, r14
	movs	pc, r14				; return

