<?xml version="1.0" encoding="Shift_JIS"?>

<!-- XSLT stylesheet for ChaOne              -->
<!--                     for msxml and exslt -->
<!--                            ver. 1.3.0a1 -->
<!--                        for UniDic 1.2.0 -->
<!-- ChaOne consists of the followings;      -->
<!--  (2) Phonetic Alternation               -->
<!--                2006-10-12 by Studio ARC -->
<!-- Copyright (c) 2004-2006 Studio ARC      -->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  xmlns:msxml="urn:schemas-microsoft-com:xslt"
  xmlns:ext="http://exslt.org/common"
  exclude-result-prefixes="exsl msxml ext"
  version="1.0"
  xml:lang="ja">

  <xsl:output method="xml" encoding="Shift_JIS" omit-xml-declaration="yes" indent="yes"/>

  <xsl:variable name="IPA_table" select="document('IPAfn.xml')"/>
  <xsl:variable name="FPA_table" select="document('FPAfn.xml')"/>
  <xsl:key name="IPAfn" match="ifn" use="concat(@iType, @iForm, @iConType)"/>
  <xsl:key name="FPAfn" match="ffn" use="concat(@fType, @fForm, @fConType)"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="S">
    <xsl:copy>
      <xsl:apply-templates mode="chaone"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="@*|node()" mode="chaone">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" mode="chaone"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="W2[not(@pron)]" mode="chaone">
    <!-- pronȂW2ɑ΂鉹C֏ -->
    <!-- W2̎qvfłeW1ɂĂ̏ -->
    <xsl:variable name="W1-list">
      <xsl:apply-templates select="W1" mode="alt"/>
    </xsl:variable>
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="pron">
        <xsl:for-each select="ext:node-set($W1-list)/W1">
          <xsl:value-of select="@pron"/>
        </xsl:for-each>
      </xsl:attribute>
      <xsl:copy-of select="$W1-list"/>
    </xsl:copy>
  </xsl:template>

  <!-- ChaOne inside W2 -->
  <xsl:template match="W1" mode="alt">
    <xsl:variable name="iForm_position">
      <xsl:if test="@iType">
        <xsl:call-template name="calc-iForm_position"/>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="fForm_position">
      <xsl:if test="@fType">
        <xsl:call-template name="calc-fForm_position"/>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="position">
      <xsl:choose>
        <xsl:when test="$iForm_position > 0">
          <xsl:value-of select="$iForm_position"/>
        </xsl:when>
        <xsl:when test="$fForm_position > 0">
          <xsl:value-of select="$fForm_position"/>
        </xsl:when>
        <xsl:otherwise>
          <!-- select {` (here ???) -->

          <xsl:value-of select="1"/>

        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:copy>
      <xsl:for-each select="@*">
        <xsl:call-template name="nth_attr">
          <xsl:with-param name="position" select="$position"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="nth_attr">
    <!-- current() = W1/@* -->
    <!-- return nth value (slash separated) of attribute -->
    <xsl:param name="position"/>
    <xsl:attribute name="{name()}">
      <xsl:choose>
        <xsl:when test="contains(., '/')">
          <xsl:call-template name="nth_val">
            <xsl:with-param name="position" select="$position"/>
            <xsl:with-param name="pre" select="substring-before(., '{')"/>
            <xsl:with-param name="post" select="substring-after(., '}')"/>
            <xsl:with-param name="body" select="substring-before(substring-after(., '{'), '}')"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
  </xsl:template>

  <xsl:template name="nth_val">
    <!-- current() = W1/@* -->
    <!-- return nth value (slash separated) of attribute -->
    <!-- recursive -->
    <xsl:param name="position"/>
    <xsl:param name="pre"/>
    <xsl:param name="post"/>
    <xsl:param name="body"/>
    <xsl:choose>
      <xsl:when test="$position = 1">
        <xsl:choose>
          <xsl:when test="contains($body, '/')">
            <xsl:value-of select="concat($pre, substring-before($body, '/'), $post)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat($pre, $body, $post)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="nth_val">
          <xsl:with-param name="position" select="$position - 1"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
          <xsl:with-param name="body" select="substring-after($body, '/')"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="calc-iForm_position">
    <!-- current() = W1 -->
    <!-- returns position (nth) of iForm or position of {` -->
    <xsl:call-template name="calc-iForm_position_main">
      <xsl:with-param name="iType" select="@iType"/>
      <xsl:with-param name="iConType">
        <xsl:call-template name="get_first">
          <xsl:with-param name="list" select="preceding-sibling::W1[1]/@iConType"/>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="pre" select="substring-before(@iForm, '{')"/>
      <xsl:with-param name="post" select="substring-after(@iForm, '}')"/>
      <xsl:with-param name="iForms" select="substring-before(substring-after(@iForm, '{'), '}')"/>
      <xsl:with-param name="position" select="1"/>
      <xsl:with-param name="kihonkei" select="0"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="get_first">
    <xsl:param name="list"/>
    <xsl:choose>
      <xsl:when test="contains($list, '{')">
        <xsl:call-template name="get_first_main">
          <xsl:with-param name="pre" select="substring-before($list, '{')"/>
          <xsl:with-param name="post" select="substring-after($list, '}')"/>
          <xsl:with-param name="list" select="substring-before(substring-after($list, '{'), '}')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$list"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="get_first_main">
    <xsl:param name="pre"/>
    <xsl:param name="post"/>
    <xsl:param name="list"/>
    <xsl:choose>
      <xsl:when test="contains($list, '/')">
        <xsl:variable name="first" select="substring-before($list, '/')"/>
        <xsl:choose>
          <xsl:when test="string-length($first) = 0">
            <xsl:call-template name="get_first_main">
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="$post"/>
              <xsl:with-param name="list" select="substring-after($list, '/')"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat($pre, $first, $post)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat($pre, $list, $post)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="calc-iForm_position_main">
    <!-- current() = W1 -->
    <!-- returns position (nth) of iForm whose ifn value = 1 -->
    <!-- recursive -->
    <xsl:param name="iType"/>
    <xsl:param name="iConType"/>
    <xsl:param name="pre"/>
    <xsl:param name="post"/>
    <xsl:param name="iForms"/>
    <xsl:param name="position"/>
    <xsl:param name="kihonkei"/>
    <xsl:variable name="iForm">
      <xsl:choose>
        <xsl:when test="contains($iForms, '/')">
          <xsl:value-of select="concat($pre, substring-before($iForms, '/'), $post)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($pre, $iForms, $post)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="iForm_val">
      <xsl:for-each select="$IPA_table">
        <xsl:value-of select="key('IPAfn', concat($iType, $iForm, $iConType))/@val"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$iForm_val = 1">
        <xsl:value-of select="$position"/>
      </xsl:when>
      <xsl:when test="contains($iForms, '/')">
        <xsl:call-template name="calc-iForm_position_main">
          <xsl:with-param name="iType" select="$iType"/>
          <xsl:with-param name="iConType" select="$iConType"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
          <xsl:with-param name="iForms" select="substring-after($iForms, '/')"/>
          <xsl:with-param name="position" select="$position + 1"/>
          <xsl:with-param name="kihonkei">
            <xsl:choose>
              <xsl:when test="($iForm = '{`') and ($kihonkei = 0)">
                <xsl:value-of select="$position"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$kihonkei"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$kihonkei"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="calc-fForm_position">
    <!-- current() = W1 -->
    <!-- returns position (nth) of fForm or position of {` -->
    <xsl:variable name="fConTypes" select="following-sibling::W1[1]/@fConType"/>
    <xsl:call-template name="calc-fForm_position_main">
      <xsl:with-param name="fType">
        <xsl:call-template name="get_first">
          <xsl:with-param name="list" select="@fType"/>
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="fConType">
        <xsl:choose>
          <xsl:when test="contains($fConTypes, ',')">
            <xsl:value-of select="substring-before($fConTypes, ',')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$fConTypes"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:with-param>
      <xsl:with-param name="pre" select="substring-before(@fForm, '{')"/>
      <xsl:with-param name="post" select="substring-after(@fForm, '}')"/>
      <xsl:with-param name="fForms" select="substring-before(substring-after(@fForm, '{'), '}')"/>
      <xsl:with-param name="position" select="1"/>
      <xsl:with-param name="kihonkei" select="0"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="calc-fForm_position_main">
    <!-- current() = W1 -->
    <!-- returns position (nth) of fForm whose ffn value = 1 -->
    <!-- recursive -->
    <xsl:param name="fType"/>
    <xsl:param name="fConType"/>
    <xsl:param name="pre"/>
    <xsl:param name="post"/>
    <xsl:param name="fForms"/>
    <xsl:param name="position"/>
    <xsl:param name="kihonkei"/>
    <xsl:variable name="fForm">
      <xsl:choose>
        <xsl:when test="contains($fForms, '/')">
          <xsl:value-of select="concat($pre, substring-before($fForms, '/'), $post)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($pre, $fForms, $post)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="fForm_val">
      <xsl:for-each select="$FPA_table">
        <xsl:value-of select="key('FPAfn', concat($fType, $fForm, $fConType))/@val"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$fForm_val = 1">
        <xsl:value-of select="$position"/>
      </xsl:when>
      <xsl:when test="contains($fForms, '/')">
        <xsl:call-template name="calc-fForm_position_main">
          <xsl:with-param name="fType" select="$fType"/>
          <xsl:with-param name="fConType" select="$fConType"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
          <xsl:with-param name="fForms" select="substring-after($fForms, '/')"/>
          <xsl:with-param name="position" select="$position + 1"/>
          <xsl:with-param name="kihonkei">
            <xsl:choose>
              <xsl:when test="($fForm = '{`') and ($kihonkei = 0)">
                <xsl:value-of select="$position"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$kihonkei"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$kihonkei"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
