#!/usr/bin/perl
# segment.pl: Julius$B$rMxMQ$7$?%;%0%a%s%F!<%7%g%s%D!<%k(B
#
# $Id: segment.pl,v 1.2 2006/10/16 03:57:59 sako Exp $
#
# perform forced alignment using Julian
#
# usage: segment_julian.pl speechfile transfile
#
# output will be written to 'trans.align', and
# Julian log will be stored in 'trans.log'
#

######################################################################
######################################################################
#### user configuration
use File::Basename;
$script_base = dirname( $0);

require $script_base . '/config.pl';

## julian executable
$julianbin="${julius_dickit}/bin/julian";

## acoustic model
$hmmdefs="${julius_dickit}/model/phone_m/hmmdefs_monof_mix16_gid.binhmm";

## HMMList file (needed if above is triphone based model)
#$hlist="/somewhere/IPA99/phone_m/parms/logicalTri.added";

## working directory
$TMPDIR="${tmpdir}";

## other options to Julian
$OPTARGS="-quiet -input rawfile";	# raw speech file input
#$OPTARGS="-input mfcfile";	# MFCC file input

## enable debug message
$debug_flag=0;			# set to 1 for debug output to speechfile.log
$julianlog="${TMPDIR}/julian.log";

######################################################################
######################################################################

#### initialize
if ($#ARGV < 1) {
    print "usage: segment_julian.pl speech_file trans_file\n";
    exit;
}
$speechfile = $ARGV[0];
$transfile  = $ARGV[1];
$logfile = $ARGV[2];

$transfilelog = ${TMPDIR} . "/" . basename($ARGV[1]) . ".log";

if (! -r $speechfile) {
    die "Error: cannot open speech file \"$speechfile\"\n";
}
if (! -r $transfile) {
    die "Error: cannot open trans. file \"$transfile\"\n";
}

#### open result file for writing
open(RESULT, ">$logfile") || die "Error: cannot open result file \"$logfile\"\n";

#### generate speech grammar 'tmp.dfa' and 'tmp.dict' from transcription

# clean temporary file
unlink("$TMPDIR/tmp.dfa") if (-r "$TMPDIR/tmp.dfa");
unlink("$TMPDIR/tmp.dict") if (-r "$TMPDIR/tmp.dict");

## load .lab style transcription
open(TRANS0, "$transfile") || die "Error: cannot open transcription file";
@phoneme_list_hts=();
@phoneme_list_julius=();
while(<TRANS0>) {
	chomp;
	push(phoneme_list_hts,$_);
	s/A/a/;
	s/I/i/;
	s/U/u/;
	s/E/e/;
	s/O/o/;
	s/cl/q/;
	s/pau/sp/;
	push(phoneme_list_julius,$_);
}
@phoneme_list_julius[0] = "silB";
@phoneme_list_julius[$#phoneme_list_julius] = "silE";

## read transcription
#print RESULT "--- transcription ---\n";
@words=();
#open(TRANS, "$transfile") || die "Error: cannot open speech file \"$transfile\"\n";
#while(<TRANS>) {
#    chomp;
#    next if /^[ \t\n]*$/;
#    push(words, $_);
#    print RESULT "$_\n";
#}
push(words, join( " ", @phoneme_list_julius));

#close(TRANS);
$num = $#words;

# write dfa
#print RESULT "--- generated DFA ---\n";
open(DFA, ">$TMPDIR/tmp.dfa") || die "Error: cannot open $TMPDIR/tmp.dfa for writing\n";
for ($i = 0; $i <= $num; $i++) {
    $str = sprintf("%d %d %d 0", $i, $num - $i, $i + 1);
    if ($i == 0) {
	$str .= " 1\n";
    } else {
	$str .= " 0\n";
    }
    print DFA "$str";
#    print RESULT "$str";
}
$str = sprintf("%d -1 -1 1 0\n", $num + 1);
print DFA "$str";
#print RESULT "$str";
close(DFA);

# write dict
#print RESULT "--- generated dict ---\n";
open(DICT, ">$TMPDIR/tmp.dict") || die "Error: cannot open $TMPDIR/tmp.dict for writing\n";
for ($i = 0; $i <= $num; $i++) {
    $w = shift(@words);
    $str = "$i [w_$i] $w\n";
    print DICT "$str";
#    print RESULT "$str";
}
### (ri) quick hack to avoid error in Julian 3.4 and 3.4.1...
if ($num == 0) {
    $str = "$num [w_$num] $w\n";
    print DICT "$str";
#    print RESULT "$str";
}
###
close(DICT);

#print RESULT "----------------------\n\n";

# check generated files
if ((! -r "$TMPDIR/tmp.dfa") || (! -f "$TMPDIR/tmp.dfa")) {
    die "Error: failed to make \"$TMPDIR/tmp.dfa\"\n";
}
if ((! -r "$TMPDIR/tmp.dict") || (! -f "$TMPDIR/tmp.dict")) {
    die "Error: failed to make \"$TMPDIR/tmp.dict\"\n";
}

#### execute Julian and store the output to log
$command = "echo $speechfile | $julianbin -h $hmmdefs -dfa $TMPDIR/tmp.dfa -v $TMPDIR/tmp.dict -palign";
if ($num > 0) {		# more than 1 line in trans
    $command .= " -walign";
}
if ($hlist ne "") {
    $command .= " -hlist $hlist";
}
$command .= " $OPTARGS";
$command .= " -debug" if ($debug_flag != 0);

system("$command > ${transfilelog} 2>${julianlog}");

#### remove temporary file
unlink("$TMPDIR/tmp.dfa");
unlink("$TMPDIR/tmp.dict");

#### parse log and append result to speechfile.align
#print RESULT "============ ALIGNMENT RESULT ============\n";
$sw = 0;
@seg_result=();
open(LOG, "${transfilelog}") || die "Error: cannot open julian log file\n";
$line=0;
while(<LOG>) {
	chomp;
	if( /^[0-9, ]*:/ && /[a-z,A-Z]$/){
		@item = split( " ", $_);
		printf RESULT "%d %d %s\n", 100000*$item[1],100000*($item[2]+1), $phoneme_list_hts[$line];
		$line++;
	}
}

close(LOG);
close(RESULT);

#### end of processing
unlink( "${julianlog}");
unlink( "${transfilelog}");
# print "$score\n";
