#include "stdafx.h"
#include "resource.h"

#include "FWatchApp.hpp"

#include "Utility.hpp"

#include "SettingInfoFactory.hpp"
#include "WatchThreadGroup.hpp"
#include "FileIO.hpp"
#include "Crypt.hpp"

#include <assert.h>

#include <sstream>


// ǂݍ݉\o[WmF
static LPCTSTR VERSION_SIG1 = _T(";fwatch-version:1.7");
static LPCTSTR VERSION_SIG2 = _T(";fwatch-version:1.8");

// ݗpo[W
static LPCTSTR VERSION_WRITE_SIG = _T(";fwatch-version:1.8.0.3\r\n");


//////////////////////////////////////////////

CWatchThreadGroup::CWatchThreadGroup( const bool v_dryrun )
	: modified_(false)
	, dryrun_(v_dryrun)
{
}

void CWatchThreadGroup::ReleaseAllThreads()
{
	// ~߂ׂẴXbhɑM(ҋ@͂ȂB)
	for (CWatchThreadList::iterator ite = watchList_.begin();
		ite != watchList_.end();
		++ite) {
		CWatchThread* pWatchThread = *ite;
		pWatchThread->StopNoWait();
	}

	// ׂẴXbhjB(X̃Xbh̔jҋ@)
	for (CWatchThreadList::iterator ite = watchList_.begin();
		ite != watchList_.end();
		++ite) {
		CWatchThread* pWatchThread = *ite;
		delete pWatchThread;
	}

	watchList_.clear();
	modified_ = false;
}

CWatchThreadGroup::~CWatchThreadGroup()
{
	ReleaseAllThreads();
}

bool CWatchThreadGroup::isDryrRun() const
{
	return dryrun_;
}


bool CWatchThreadGroup::LoadInfData(const tstring& InfPath)
{
	if (InfPath.empty()) {
		return false;
	}

	ReleaseAllThreads();

	bool succeeded = false;
	try {
		// t@CI[v
		CFileIO fileIO(InfPath);
		if (!fileIO.Open(false)) {
			return false;
		}

		// Í
		CCrypt crypt;
		tstring password = app.GetImpersonatePasswordEncryption();

		const CSettingInfo init;
		bool sigChecked = false;
		bool enableScaped = false;

		tstring line;
		while (fileIO.GetText(line)) {

			// ŏ̍s̃o[W`FbN
			if ( !sigChecked) {
				sigChecked = true;

				tstring sig1(VERSION_SIG1);
				tstring sig2(VERSION_SIG2);
				if ((line.length() >= sig1.length() && line.substr(0, sig1.length()) == sig1) ||
					(line.length() >= sig2.length() && line.substr(0, sig2.length()) == sig2)) {
					// `FbNOK
					enableScaped = true;
					continue;
				}
				else if (fileIO.IsUnicode()) {
					// UNICODE̐ݒt@Ĉ݃o[W̐`FbNB
					// (MBCS`̐ݒt@C͋ݒt@C̓ǂݍ݂lă`FbNȂB)
					throw std::runtime_error("incompatible version");
				}
			}

			// Rgs
			if (line.length() >= 1 && line[0] == ';') {
				// 擪u;vł΃RgsƂ݂ȂăXLbvB
				continue;
			}


			CSettingInfoFactory factory(init);

			tstring userName;
			int col = 0;
			tstring::size_type lastpos = 0;
			for (;;) {
				const tstring::size_type pos = line.find('\t', lastpos);
				tstring arg;
				if (pos != tstring::npos) {
					arg = line.substr(lastpos, pos - lastpos);
				}
				else {
					arg = line.substr(lastpos);
				}

				// version1.7ȍ~̌`Ȃ΃GXP[v󂯓B
				if (enableScaped) {
					arg = UnescapeUnprintableChars(arg);
				}

				// ڂ̓ǂݎ
				switch(col)
				{
				case 0:
					factory.setWatchDir(arg);
					break;

				case 1:
					factory.setWatchFile(arg);
					break;

				case 2:
					factory.setAction(arg);
					break;

				case 3:
					factory.setAppName(arg);
					break;

				case 4:
					factory.setParam(arg);
					break;

				case 5:
					factory.setMaxProcess(atoi(arg));
					break;

				case 6:
					factory.setShowWindow( ShowWindowType::valueOf(atoi(arg)));
					break;

				case 7:
					factory.setWaitWrite(atoi(arg));
					break;

				case 8:
					factory.setTolerance(atoi(arg));
					break;

				case 9:
					factory.setDeletePending(atoi(arg));
					break;

				case 10:
					factory.setLog(arg);
					break;

				case 11:
					factory.setMaxDepth(atoi(arg));
					break;

				case 12:
					factory.setUsingDirNotificationAPI(atoi(arg) != 0);
					break;

				case 13:
					factory.setForceInterval(atoi(arg));
					break;

				case 14:
					factory.setDirNotificationAPIExpirySpan(atoi(arg));
					break;

				case 15:
					factory.setDirNotificationAPIRetryInterval(atoi(arg));
					break;

				case 16:
					factory.setLogLevel(atoi(arg));
					break;

				case 17:
					factory.setAppCurrentDir(arg);
					break;

				case 18:
					factory.setPersist(arg);
					break;

				case 19:
					factory.setArchiveOnly(atoi(arg) != 0);
					break;

				case 20:
					factory.setNotifyOnStart(atoi(arg) != 0);
					break;

				case 21:
					factory.setWatchDelay(atoi(arg));
					break;

				case 22:
					factory.setIgnoreDuplicate(atoi(arg) != 0);
					break;

				case 23:
					factory.setImpersonate(atoi(arg) != 0);
					break;

				case 24:
					{
						factory.setImpersonateUser(arg);
						userName = arg;
					}
					break;

				case 25:
					factory.setImpersonateDomain(arg);
					break;

				case 26:
					{
						if (userName.empty() || arg.empty() || password.empty()) {
							// [U܂̓pX[hA܂inĩpX[hł
							// ϊȂB
							if (userName.empty()) {
								// [Uł΃pX[hƂB
								factory.setImpersonatePassword(_T(""));
							}
							else {
								factory.setImpersonatePassword(arg);
							}
						}
						else {
							// łȂΈÍs
							tstring saltPassword = userName;
							saltPassword += _T(":fw:");
							saltPassword += password;
							
							tstring decryptPassword;
							try {
								crypt.decrypt(saltPassword, arg, decryptPassword);
							}
							catch (const CCryptException& exception) {
								DWORD err = exception.GetErrorCode();
								app.showMessageBox(
									MB_ICONERROR | MB_OK,
									NULL,
									IDS_MAINPROC_INFLOADFAILED_DECRYPT,
									ToErrorMessage(err).c_str());
								// pX[hɂČpB
								decryptPassword.clear();
							}

							factory.setImpersonatePassword(decryptPassword);
						}
					}
					break;

				case 27:
					factory.setWatchDisabled(atoi(arg) != 0);
					break;

				default:
					break;
				}

				col++;
				lastpos = pos + 1;
				if (pos == std::string::npos) {
					break;
				}
			}

			append(factory.create());
		}
		succeeded = true;
	}
	catch (const CCryptException& v_exception) {
		DWORD err = v_exception.GetErrorCode();
		app.showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFLOADFAILED, ToErrorMessage(err).c_str());
	}
	catch (const CFileIOException& v_exception) {
		DWORD err = v_exception.GetErrorCode();
		app.showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFLOADFAILED, ToErrorMessage(err).c_str());
	}
	catch (const std::exception& v_exception) {
		const char *pMes = v_exception.what();
		CA2T mes(pMes ? pMes : "");
		app.showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFLOADFAILED, mes);
	}

	modified_ = false;
	return succeeded;
}

bool CWatchThreadGroup::isModified() const
{
	return modified_;
}

bool CWatchThreadGroup::SaveInfData(const tstring& InfPath, bool v_bForce) const
{
	if (InfPath.empty()) {
		return false;
	}

	if ( !isModified() && ! v_bForce) {
		return true;
	}

	bool succeeded = false;
	try {
		// o͐obt@m
		tstringstream fout;

		// Í
		CCrypt crypt;
		tstring password = app.GetImpersonatePasswordEncryption();
		const CCrypt::algtype* pAlgType = NULL;
		if ( !password.empty()) {
			// pX[hΈÍASY肷B
			pAlgType = &crypt.chooseAlgorithm();
		}

		// version 
		fout << VERSION_WRITE_SIG;

		// watch-list
		for (CWatchThreadList::const_iterator ite = watchList_.begin();
			ite != watchList_.end();
			++ite )
		{
			const CWatchThread* pWatchThread = *ite;
			const CSettingInfo& settingInfo = pWatchThread->getSettingInfo();

			LPCTSTR tab = _T("\t");

			// pX[ḧÍ
			tstring encryptedPassword;
			tstring impersonateUser = settingInfo.getImpersonateUser();
			if ( !impersonateUser.empty()) {
				// [Uw肳Ăꍇ̂݃pX[hۑB
				tstring impersonatePassword = settingInfo.getImpersonatePassword();
				if (pAlgType == NULL) {
					// ÍASYȂΕ̂܂
					encryptedPassword = impersonatePassword;
				}
				else {
					// pX[h̗L킸AÍASYΈÍB
					tstring saltPassword = impersonateUser;
					saltPassword += _T(":fw:");
					saltPassword += password;
					
					crypt.encrypt(saltPassword, *pAlgType, impersonatePassword, encryptedPassword);
				}
			}

			// ڂ̏o
			fout << EscapeUnprintableChars(settingInfo.getWatchDir())	<< tab;
			fout << EscapeUnprintableChars(settingInfo.getWatchFile())	<< tab;
			fout << EscapeUnprintableChars(settingInfo.getAction())		<< tab;
			fout << EscapeUnprintableChars(settingInfo.getAppName())	<< tab;
			fout << EscapeUnprintableChars(settingInfo.getParam())		<< tab;
			fout << settingInfo.getMaxProcess()	<< tab;
			fout << settingInfo.getShowWindow()	<< tab;
			fout << settingInfo.getWaitWrite()	<< tab;
			fout << settingInfo.getTolerance()	<< tab;
			fout << settingInfo.getDeletePending() << tab;
			fout << EscapeUnprintableChars(settingInfo.getLog())		<< tab;
			fout << settingInfo.getMaxDepth()	<< tab;
			fout << (settingInfo.isUsingDirNotificationAPI() ? 1 : 0)	<< tab;
			fout << settingInfo.getForceInterval()						<< tab;
			fout << settingInfo.getDirNotificationAPIExpirySpan()		<< tab;
			fout << settingInfo.getDirNotificationAPIRetryInterval()	<< tab;
			fout << settingInfo.getLogLevel()	<< tab;
			fout << EscapeUnprintableChars(settingInfo.getAppCurrentDir()) << tab;
			fout << EscapeUnprintableChars(settingInfo.getPersist()) << tab;
			fout << (settingInfo.isArchiveOnly() ? 1 : 0) << tab;
			fout << (settingInfo.isNotifyOnStart() ? 1 : 0) << tab;
			fout << settingInfo.getWatchDelay() << tab;
			fout << (settingInfo.isIgnoreDuplicate() ? 1 : 0) << tab;
			fout << (settingInfo.isImpersonate() ? 1 : 0) << tab;
			fout << EscapeUnprintableChars(settingInfo.getImpersonateUser()) << tab;
			fout << EscapeUnprintableChars(settingInfo.getImpersonateDomain()) << tab;
			fout << EscapeUnprintableChars(encryptedPassword) << tab;
			fout << (settingInfo.isWatchDisabled() ? 1 : 0) << _T("\r\n");
		}

		tstring line = fout.str();

		CFileIO writer(InfPath);
		writer.Open(true);
		writer.PutText(line);

		modified_ = false;
		succeeded = true;
	}
	catch (const CCryptException& v_exception) {
		DWORD err = v_exception.GetErrorCode();
		app.showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFLOADFAILED, ToErrorMessage(err).c_str());
	}
	catch (const CFileIOException& v_exception) {
		DWORD err = v_exception.GetErrorCode();
		app.showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFSAVEFAILED, ToErrorMessage(err).c_str());
	}
	catch (const std::exception& v_exception) {
		const char *pMes = v_exception.what();
		CA2T mes(pMes ? pMes : "");
		app.showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFSAVEFAILED, mes);
	}

	return succeeded;
}

/*!
 * ł͂ȂAׂẴXbhJn܂B
 * łɊJnς݂͉̂̂܂B
 */
void CWatchThreadGroup::startAll()
{
	for (CWatchThreadList::iterator ite = watchList_.begin();
		ite != watchList_.end();
		++ite)
	{
		CWatchThread* pWatchThread = *ite;
		if ( !pWatchThread->getSettingInfo().isWatchDisabled() && !pWatchThread->isRunning()) {
			pWatchThread->Start();
		}
	}
}

/*!
 * w肵XbhJn܂B
 * ɊJnς݂łΉ܂B
 * Xbh̊ĎfBZ[uwłĂJn܂B
 * \return łɊJnĂ邩JnꂽꍇtrueAJnłȂꍇfalse
 */
bool CWatchThreadGroup::start(unsigned int idx)
{
	if (idx >= watchList_.size()) {
		assert(false && "݂ȂACeɂ̓ANZXł܂B");
		return false;
	}

	watchList_[idx]->Start();
	return true;
}

/*!
 * w肵Xbh~܂B
 * łɒ~ς݂łΉ܂B
 * \return Xbhɒ~ς݂ł邩~ꂽꍇtrueA莞Iꍇfalse
 */
bool CWatchThreadGroup::stop(unsigned int idx)
{
	if (idx >= watchList_.size()) {
		assert(false && "݂ȂACeɂ̓ANZXł܂B");
		return false;
	}

	watchList_[idx]->Stop();
	return true;
}

unsigned int CWatchThreadGroup::size() const
{
	return watchList_.size();
}

const CSettingInfo& CWatchThreadGroup::getInfo(unsigned int idx) const
{
	//required:
	assert(idx >= 0 && idx < watchList_.size() && "݂ȂACeɂ̓ANZXł܂B");
	
	//do:
	return watchList_[idx]->getSettingInfo();
}

CWatchThread *CWatchThreadGroup::append(const CSettingInfo& v_settingInfo)
{
	CWatchThread* pWatchThread = new CWatchThread(v_settingInfo);
	watchList_.push_back(pWatchThread);
	modified_ = true;
	return pWatchThread;
}

CWatchThread *CWatchThreadGroup::replace(unsigned int idx, const CSettingInfo& v_settingInfo)
{
	//required:
	if (idx >= watchList_.size()) {
		assert(false && "݂ȂACeɂ̓ANZXł܂B");
		return NULL;
	}
	
	//do:

	if (watchList_[idx]->getSettingInfo() == v_settingInfo) {
		// ύX_Ȃꍇ
		return watchList_[idx];
	}

	delete watchList_[idx];
	CWatchThread *const pWatchThread = new CWatchThread(v_settingInfo);

	watchList_[idx] = pWatchThread;
	modified_ = true;
	return pWatchThread;
}

bool CWatchThreadGroup::erase(unsigned int idx)
{
	//required:
	if (idx >= watchList_.size()) {
		assert(false && "͈͊OłB");
		return false;
	}

	//do:
	CWatchThreadList::iterator ite = watchList_.begin() + idx;
	delete *ite;
	watchList_.erase(ite);
	modified_ = true;
	return true;
}

bool CWatchThreadGroup::isRunning() const
{
	for (CWatchThreadList::const_iterator ite = watchList_.begin();
		ite != watchList_.end();
		++ite)
	{
		const CWatchThread* pWatchThread = *ite;
		if (pWatchThread->isRunning()) {
			return true;
		}
	}
	return false;
}

bool CWatchThreadGroup::isRunning(unsigned int idx) const
{
	//required:
	assert(idx >= 0 && idx < watchList_.size() && "͈͊OłB");

	//do:
	return watchList_[idx]->isRunning();
}


void CWatchThreadGroup::ClearLog(const CSettingInfo& settingInfo) const
{
	tstring logPath = settingInfo.getLog();
	if ( !settingInfo.isEnableLogging() || logPath.empty()) {
		// Oo͂Ȃꍇ͊֌WȂ
		return;
	}

	// gp̃bNIuWFNgΏB
	// (Ot@C̓ɎgpĂ̂̂ŁAꊇďB)
	// (ݒύXŃOt@CςꍇɁA
	// gȂȂOt@C̃bNIuWFNgĉh߁B)
	app.RemoveUnusedLock();

	// s̃Xbhœ̃OgpĂ̂邩肷B
	bool alreadyUsed = false;
	for (CWatchThreadList::const_iterator ite = watchList_.begin();
		ite != watchList_.end();
		++ite)
	{
		const CWatchThread* pWatchThread = *ite;
		if (pWatchThread->isRunning()) {
			const CSettingInfo& otherSettingInfo = pWatchThread->getSettingInfo();
			tstring otherLogPath = otherSettingInfo.getLog();
			if (otherSettingInfo.isEnableLogging()) {
				if (_tcsicmp(logPath.c_str(), otherLogPath.c_str()) == 0) {
					alreadyUsed = true;
					break;
				}
			}
		}
	}

	if (!alreadyUsed) {
		// ̊ĎXbhŃOgpĂ炸A
		// ݒt@CɂăOwĂꍇ̓O폜B
		if (app.IsDeleteLog()) {
			DeleteFile(logPath.c_str());
		}
	}
}
