#include "stdafx.h"

#include "FWatchApp.hpp"
#include "Logger.hpp"

#include "Utility.hpp"

#include <vector>
#include <string>
#include <memory>

#include <assert.h>

#include <strsafe.h>
#pragma comment(lib, "strsafe.lib")


int FileLogger::GetLogThreshold() const
{
	return logThreshold_;
}

void FileLogger::SetLogThreshold(int logLevel)
{
	logThreshold_ = logLevel;
}


FileLogger::FileLogger()
	: enabled_(false)
	, logThreshold_(0)
	, lastWrite_(FILETIME())
	, hLogFile_(INVALID_HANDLE_VALUE)
{
	lockTryLimit_ = (int) app.GetLong(_T("CONFIG"), _T("LOGEXCLUSIVELOCK"), 30);
}

FileLogger::FileLogger(LPCTSTR logPath)
	: enabled_(logPath && *logPath)
	, logThreshold_(0)
	, lastWrite_(FILETIME())
	, hLogFile_(INVALID_HANDLE_VALUE)
	, logPath_(logPath)
{
}

FileLogger::~FileLogger() throw()
{
	Close();
}

bool FileLogger::IsOpened() const
{
	return hLogFile_ != INVALID_HANDLE_VALUE;
}

bool FileLogger::Open()
{
	// łɊJĂ΁AȂB
	if (IsOpened()) {
		return true;
	}

	// Oł邩AOt@Cw肳ĂȂΉȂ
	LPCTSTR logpath = GetLogPath();
	if ( !IsEnableLogging() || !logpath || !*logpath) {
		return false;
	}

	// t@CǋL[hŊJBȂ΍쐬B
	// ǂݏL[hŁAꃍOt@CŕXbhANZXł悤ɂB
	hLogFile_ = ::CreateFile(
		logpath,
		GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,
		OPEN_ALWAYS,
		FILE_ATTRIBUTE_NORMAL,
		NULL
		);
	return hLogFile_ != INVALID_HANDLE_VALUE;
}

void FileLogger::Close()
{
	if (hLogFile_ != INVALID_HANDLE_VALUE) {
		LogMessage(10, NULL, 0, _T("close log."));
		::CloseHandle(hLogFile_);
		hLogFile_ = INVALID_HANDLE_VALUE;
	}
}

LPCTSTR FileLogger::GetLogPath() const throw()
{
	return logPath_.c_str();
}

void FileLogger::SetLogPath(LPCTSTR logPath) throw()
{
	logPath_ = logPath ? logPath : _T("");
}

void FileLogger::SetEnableLogging(bool enabled) throw()
{
	enabled_ = enabled;
}

bool FileLogger::IsEnableLogging() const throw()
{
	return enabled_ && logPath_.length() > 0;
}


/*!
 * Ot@CɏށB
 * OLɂȂĂȂAOt@C̏ꍇ͏o͂ȂB
 * ܂AȌ݂ɎsĂG[͕ԂȂB
 * Ot@C̓OނтɒǋL[hŃI[vď݌㑦ɃN[YB
 * ݂̓Ot@C̊ĎXbhœłꍇz肵ď݂͔rbNB
 * \param logLevel Ox
 * \param systime ^CX^vAnull̏ꍇ͌ݎgpB
 * \param errcode Win32̃G[R[hA0ȊȌꍇ̓Oɏo͂B
 * \param mes bZ[W1Anull̏ꍇ͋󕶎
 */
void FileLogger::LogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, LPCTSTR mes)
{
	// o͂郍ÕOx臒lƓ(Dx)ꍇ̂ݏo͂B
	if (logLevel > logThreshold_) {
		return;
	}

	// t@CJ(KvȂ)
	if (!Open()) {
		// JȂꍇA̓Oo͂Ȃꍇ͂ɖ߂B
		return;
	}

	// bNJn
	// (vZXɂrAfXgN^̎sŃbNB)
	tstring lockname = _T("lock:");
	lockname += GetLogPath();
	ToLower(lockname);

	std::auto_ptr<LockObject> lock(app.GetLockObject(lockname));

	// Ot@C̓tς烍[e[gB
	if (app.IsRotateLog()) {
		RotateLog();
	}

	// t@CrbN
	// (ꃍOt@Cɑ΂鑽dݎɏdȂȂ悤ɂ邽߁B)
	// (Windows9xł͖)
	FileLockObject fileLock(hLogFile_, lockTryLimit_);

	// bZ[W\zOt@Cɏo͂B
	InternalLogMessage(logLevel, systime, errcode, mes);


	// sxw΁AB
	if (app.GetLogCloseSpan() == 0) {
		// ċAɂȂ̂Close\bh͌Ă΂ȂB
		::CloseHandle(hLogFile_);
		hLogFile_ = INVALID_HANDLE_VALUE;
	}
	else {
		// sxȂ΃tbVB
		FlushFileBuffers(hLogFile_);
	}

	// Ōɏ񂾎ZbgB
	GetSystemTimeAsFileTime(&lastWrite_);
}

/*!
 * p̃Oo̓\bhB
 * ObZ[W̍\zƃt@Co͂sB
 * rbNt@C̃I[v͌ĂяoƂŏĂOƂĂB
 */
void FileLogger::InternalLogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, LPCTSTR mes)
{
	// o͂郍ÕOx臒lƓ(Dx)ꍇ̂ݏo͂B
	// (AOt@CI[vĂȂΉȂB)
	if (logLevel > logThreshold_ || hLogFile_ == INVALID_HANDLE_VALUE) {
		return;
	}

#ifdef _UNICODE
	// UNICODȄꍇŃt@C̐擪łBOM (UTF-16 ݊)
	ULARGE_INTEGER siz;
	siz.LowPart = GetFileSize(hLogFile_, &siz.HighPart);
	if (siz.LowPart != -1 || GetLastError() == NO_ERROR) {
		// G[ł͂Ȃ
		if (siz.QuadPart == 0) {
			// t@CTCY[ł
			unsigned char bom[] = {0xff, 0xfe};
			DWORD wd;
			WriteFile(hLogFile_, (LPVOID) bom, 2, &wd, NULL);
		}
	}
#endif

	// bZ[Wȗꂽꍇ͋󕶎ƂB
	if (mes == NULL) {
		mes = _T("");
	}

	// ȗꍇ͌ݎ擾.
	SYSTEMTIME tmp = {0};
	if (systime == NULL) {
		GetLocalTime(&tmp);
		systime = &tmp;
	}

	// ObZ[Wobt@
	int bufsiz = lstrlen(mes) + 64;
	if (bufsiz < 512) {
		bufsiz = 512;
	}
	std::vector<TCHAR> buf(bufsiz);

	// ObZ[W\z.
	HRESULT hr;
	hr = StringCbPrintf(
		&buf[0],
		bufsiz * sizeof(TCHAR),
		_T("*%04d/%02d/%02d %02d:%02d:%02d.%03d (%d) [%04x] %s\r\n"),
		systime->wYear,
		systime->wMonth,
		systime->wDay,
		systime->wHour,
		systime->wMinute,
		systime->wSecond,
		systime->wMilliseconds,
		logLevel,
		::GetCurrentThreadId(),
		mes
		);
	if (FAILED(hr)) {
		assert(false && "bZ[W̍\zɎs܂B");
		return;
	}

	// ɃV[N.
	::SetFilePointer(hLogFile_, 0, NULL, FILE_END);

	// 
	DWORD wd;
	WriteFile(hLogFile_, &buf[0], sizeof(TCHAR) * lstrlen(&buf[0]), &wd, NULL);

	// G[R[hG[bZ[W̐
	if (errcode != 0) {
		tstring errmsg = ToErrorMessage(errcode);
		int bufsiz2 = errmsg.length() + 64;
		std::vector<TCHAR> buf2(bufsiz2);
		hr = StringCbPrintf(
			&buf2[0],
			bufsiz2 * sizeof(TCHAR),
			_T("ERROR CODE=%d %s\r\n"),
			errcode,
			errmsg.c_str()
			);
		if (FAILED(hr)) {
			assert(false && "G[bZ[W̍\zɎs܂B");
		}
		WriteFile(hLogFile_, &buf2[0], sizeof(TCHAR) * lstrlen(&buf2[0]), &wd, NULL);
	}
}

/*!
 * bZ[WIDɂ郍Ot@CɏށB
 * ȊO͑̃\bhƓlłB
 * \param logLevel Ox
 * \param systime ^CX^vAnull̏ꍇ͌ݎgpB
 * \param errcode G[R[h
 * \param messageID bZ[WID
 */
void FileLogger::LogMessage(int logLevel, const SYSTEMTIME* systime, DWORD errcode, DWORD messageID, ...)
{
	// o͂郍ÕOx臒lƓ(Dx)ꍇ̂ݏo͂B
	if (logLevel > logThreshold_) {
		return;
	}

	// Oł邩AOt@Cw肳ĂȂΉȂ
	LPCTSTR logpath = GetLogPath();
	if ( !IsEnableLogging() || !logpath || !*logpath) {
		return;
	}

	// bZ[WtH[}bgƁAOC^ɑ
	va_list marker;
	va_start(marker, messageID);

	tstring format = app.LoadStringFormatV(messageID, marker);
	LogMessage(logLevel, systime, errcode,format.c_str());
}

/*!
 * O̓tύXĂ΃[e[g܂B
 * t@CJĂȂΊJ܂B
 * Iɕ邱Ƃ͂܂B
 */
void FileLogger::RotateLog()
{
	if (!Open()) {
		// t@CJȂAOo͂Ȃꍇ͉ȂB
	}

	// t@C̓t{łȂ΃obNAbvB
	FILETIME lastModified = {0};
	if (GetFileTime(hLogFile_, NULL, NULL, &lastModified)) {

		// tǂݎꂽꍇ̂݁B
		FILETIME localLastModified = {0};
		FileTimeToLocalFileTime(&lastModified, &localLastModified);
		SYSTEMTIME today = {0}, fileTime = {0};
		GetLocalTime(&today);
		FileTimeToSystemTime(&localLastModified, &fileTime);

		if (today.wYear != fileTime.wYear
			|| today.wMonth != fileTime.wMonth
			|| today.wDay != fileTime.wDay) {

			// Rs[OɌݎɐݒ肷B
			SystemTimeToFileTime(&today, &localLastModified);
			LocalFileTimeToFileTime(&localLastModified, &lastModified);
			SetFileTime(hLogFile_, NULL, &lastModified, &lastModified);

			// t@C̓t{łȂ̂bakt@C쐬B
			LPCTSTR logpath = GetLogPath();
			assert(logpath && "Ot@C͕K{łB");

			tstring bakFile = logpath;
			bakFile += _T(".bak");

			if (CopyFile(logpath, bakFile.c_str(), FALSE)) {

				// Rs[ɐÃt@C؂l߂
				SetFilePointer(hLogFile_, 0, NULL, FILE_BEGIN);
				SetEndOfFile(hLogFile_);
			}
		}
	}
}

const FILETIME& FileLogger::GetLastWrite() const
{
	return lastWrite_;
}

void FileLogger::Tick(const FILETIME &ftNow)
{
	DWORD logCloseSpan = app.GetLogCloseSpan() * 1000;
	if (logCloseSpan > 0 && IsOpened()) {
		if (IsExpired(ftNow, logCloseSpan, lastWrite_)) {
			Close();
		}
	}
}


///////////////////////////


FileLockObject::FileLockObject(HANDLE hFile, int maxretry)
	: hFile_(hFile)
	, locked_(false)
{
	assert(hFile_ && hFile_ != INVALID_HANDLE_VALUE && "t@Cnhsł");

	// t@CrbN
	// (ꃍOt@Cɑ΂鑽dݎɏdȂȂ悤ɂ邽߁B)
	// (Windows9xł͖)

	ZeroMemory(&overlapped_, sizeof(OVERLAPPED));
	overlapped_.Offset = 0;
	overlapped_.OffsetHigh = 0;
	overlapped_.hEvent = NULL;

	locked_ = false;
	for (int retry = 0; retry < maxretry; retry++) {
		if (LockFileEx(hFile_, LOCKFILE_FAIL_IMMEDIATELY | LOCKFILE_EXCLUSIVE_LOCK, 0, (DWORD) -1, (DWORD) -1, &overlapped_)) {
			locked_ = true;
			break;
		}
		DWORD err = GetLastError();
		if (err != ERROR_IO_PENDING) {
			break;
		}
		Sleep(100);
	}
}

FileLockObject::~FileLockObject()
{
	Release();
}

void FileLockObject::Release()
{
	if (locked_) {
		locked_ = false;
		UnlockFileEx(hFile_, 0, (DWORD) -1, (DWORD) -1, &overlapped_);
	}
}
