#pragma once

#include "WatchThread.hpp"
#include "SettingInfo.hpp"

#include <string>
#include <vector>

class CWatchThreadGroup
{
private:
	/*!
	 * hC[h
	 */
	const bool dryrun_;

	/*!
	 * ύXtO
	 */
	mutable bool modified_;

	/*!
	 * ĎXbh̃Xg
	 */
	typedef std::vector<CWatchThread*> CWatchThreadList;
	CWatchThreadList watchList_;

private:
	CWatchThreadGroup(const CWatchThreadGroup&); //<! Ȃ
	CWatchThreadGroup& operator=(const CWatchThreadGroup&); //<! Ȃ

public:
	
	/*!
	 * ĎXbhO[v\z܂B
	 * hC[hLɂƃXbh͎ۂɂ͍쐬ꂸҏŴ݂ƂȂ܂B
	 * \param v_dryrun hC[h̏ꍇAtrue
	 */
	CWatchThreadGroup(const bool v_dryrun);

	/*!
	 * ĎO[v܂B
	 * ׂẴXbh͒~܂B
	 */
	virtual ~CWatchThreadGroup();

	/*!
	 * SẴXbhATCY0ɂ܂B
	 */
	void ReleaseAllThreads();

	/*!
	 * ĎXbh擾܂B
	 * ݒ~̂̂܂܂܂B
	 * \return ĎXbh
	 */
	unsigned int size() const;

	/*!
	 * ĎXbh̊Ďݒ擾܂B
	 * \param ĎXbh̃CfbNX
	 * \return ĎXbh̊Ďݒ
	 */
	const CSettingInfo& getInfo(unsigned int idx) const;

	/*!
	 * VĎXbh쐬O[vɓo^܂B
	 * o^Xbh̃|C^Ԃ܂B
	 * ĎXbh̃|C^͊Ǘς݂̂ߌĂяodeleteKv͂܂B
	 * \param ĎXbh̃CfbNX
	 * \param v_settingInfo Ďݒ
	 * \return ĎXbh̃|C^B
	 */
	CWatchThread *append(const CSettingInfo& v_settingInfo);

	/*!
	 * ĎXbhXV܂B
	 * ݒɕύXȂꍇ̓Xbh͂̂܂܂łB
	 * ύXĂꍇ̓Xbh͍č쐬܂B
	 * č쐬ꂽA͊̊ĎXbh̃|C^Ԃ܂B
	 * ĎXbh̃|C^͊Ǘς݂̂ߌĂяodeleteKv͂܂B
	 * \param ĎXbh̃CfbNX
	 * \param v_settingInfo Ďݒ
	 * \return ĎXbh̃|C^B
	 */
	CWatchThread *replace(unsigned int idx, const CSettingInfo& v_settingInfo);

	/*!
	 * ĎXbhj܂B
	 * \param ĎXbh̃CfbNX
	 * \return jꂽꍇtrueAłȂꍇfalse
	 */
	bool erase(unsigned int idx);


	/*!
	 * ł͂ȂAׂẴXbhJn܂B
	 * łɊJnς݂͉̂̂܂B
	 */
	void startAll();

	/*!
	 * w肵XbhJn܂B
	 * ɊJnς݂łΉ܂B
	 * Xbh̊ĎfBZ[uwłĂJn܂B
	 * \return łɊJnĂ邩JnꂽꍇtrueAJnłȂꍇfalse
	 */
	bool start(unsigned int idx);

	/*!
	 * w肵Xbh~܂B
	 * łɒ~ς݂łΉ܂B
	 * \return Xbhɒ~ς݂ł邩~ꂽꍇtrueA莞Iꍇfalse
	 */
	bool stop(unsigned int idx);

	/*!
	 * Xbh쒆ł邩肵܂B
	 * ꂩ1ł쒆łtrueԂ܂B
	 * \return ꂩ̃Xbh쒆łtrue
	 */
	bool isRunning() const;

	/*!
	 * w肵Xbh쒆ł邩肵܂B
	 * \param ĎXbh̃CfbNX
	 * \return Xbh쒆łtrue
	 */
	bool isRunning(unsigned int idx) const;


	/*!
	 * hC[hł邩?
	 * \return hC[hłtrue
	 */
	bool isDryrRun() const;


	/*!
	 * ݒt@CĎݒǂݎXbhO[v\z܂B
	 * \param InfPath ĎXgt@C
	 * \return ɓǂݍ߂ꍇtrueAłȂꍇfalse
	 */
	bool LoadInfData(const tstring& InfPath);

	/*!
	 * ݂̊Ďݒݒt@Cɏ݂܂B
	 * \param InfPath ĎXgt@C
	 * \return ɏ߂ꍇtrueAłȂꍇfalse
	 */
	bool SaveInfData(const tstring& InfPath, bool bForce = false) const;

	/*!
	 * _ALoadInfDataĂяoɁAȂ炩̐ݒύX邩?
	 * \return ݒύXtrue
	 */
	bool isModified() const;

protected:

	/*!
	 * Xbh̊JnɂăȌs܂B
	 * AꃍOt@BXbhJnς݂ł΁A
	 * łɏς݂Ƃ݂ȂA̓XLbv܂B
	 * \param settingInfo Ďݒ
	 */
	void ClearLog(const CSettingInfo& settingInfo) const;
};
