#include "stdafx.h"

#include "NameMatcher.hpp"

#include "Utility.hpp"

#include <algorithm>


CNameMatcher::CNameMatcher(const tstring& pattern, const bool ignoreCase)
	: ignoreCase_(ignoreCase)
{
	// Z~R؂ŕB
	LPCTSTR p = pattern.c_str();
	LPCTSTR pSt = p;
	while (*p) {
		while (*p && *p != ';') {
			p = CharNext(p);
		}
		size_t len = p - pSt;
		if (len > 0) {
			tstring ptn(pSt, len);
			ptn = StrTrim(ptn);

			if ( !ptn.empty()) {
				// 啶EʂȂꍇ̓p^[ɑĂ
				if (ignoreCase) {
					std::transform(ptn.begin(), ptn.end(), ptn.begin(), tolower);
				}

				patterns_.push_back(ptn);
			}

			p = CharNext(p);
			pSt = p;
		}
	}
}


bool CNameMatcher::operator()(const tstring& name) const throw()
{
	const tstring *pName;

	// 啶EʂȂꍇ͔rΏۂɑ.
	tstring ignoreCaseName;
	if ( !ignoreCase_) {
		pName = &name;

	} else {
		ignoreCaseName = name;
		std::transform(ignoreCaseName.begin(), ignoreCaseName.end(), ignoreCaseName.begin(), tolower);
		pName = &ignoreCaseName;
	}

	for (std::list<tstring>::const_iterator ite = patterns_.begin();
		ite != patterns_.end();
		++ite) {
		const tstring& ptn = *ite;
		if (IsMatch(pName->c_str(), ptn.c_str())) {
			return true;
		}
	}
	return false;
}


bool CNameMatcher::empty() const throw()
{
	return patterns_.empty();
}
