#include "stdafx.h"

#include "LockManager.hpp"


#pragma once

#include <string>
#include <map>

#include <assert.h>



LockObject::LockObject(CRITICAL_SECTION *pCriticalSect)
	: owner_(true)
	, pCriticalSect_(pCriticalSect)
{
	assert(pCriticalSect && "NeBJZNVNULL͎wł܂B");

	// bNJnB
	EnterCriticalSection(pCriticalSect_);
}

LockObject::~LockObject()
{
	Release();
}

void LockObject::Release() throw()
{
	if (owner_ ) {
		owner_ = false;
		// bNIB
		// xbNA
		// ̃IuWFNgł͓xƃbNłȂƂdvB
		LeaveCriticalSection(pCriticalSect_);
	}
}


//////////////////


LockManager::LockManager()
{
	ZeroMemory(&criticalSect_, sizeof(CRITICAL_SECTION));
	::InitializeCriticalSection(&criticalSect_);
}

LockManager::~LockManager()
{
	EnterCriticalSection(&criticalSect_);
	try {
		for (critical_section_map::iterator ite = criticalSections_.begin();
			ite != criticalSections_.end();
			++ite) {
			CRITICAL_SECTION* pCriticalSect = ite->second;
			::DeleteCriticalSection(pCriticalSect);
			delete pCriticalSect;
		}
	}
	catch (...) {
		LeaveCriticalSection(&criticalSect_);
		throw;
	}
	LeaveCriticalSection(&criticalSect_);

	// bN}l[Wg̃NeBJZNVj
	::DeleteCriticalSection(&criticalSect_);
}

LockObject *LockManager::GetLockObject(const tstring& name)
{
	LockObject *pLockObject = NULL;

	EnterCriticalSection(&criticalSect_);
	try {
		CRITICAL_SECTION* pCriticalSect = NULL;
		critical_section_map::iterator ite = criticalSections_.find(name);
		if (ite == criticalSections_.end()) {
			// ꂸ = VKɍ쐬ēo^B
			pCriticalSect = new CRITICAL_SECTION();
			::InitializeCriticalSection(pCriticalSect);
			criticalSections_.insert(std::pair<tstring, CRITICAL_SECTION*>(name, pCriticalSect));

		}
		else {
			// łɂꍇ
			pCriticalSect = ite->second;
		}

		// bNԂŕԂB
		assert(pCriticalSect && "CRITICAL_SECTIONNULLłB");
		pLockObject = new LockObject(pCriticalSect);
	}
	catch (...) {
		LeaveCriticalSection(&criticalSect_);
		throw;
	}
	LeaveCriticalSection(&criticalSect_);

	assert(pLockObject && "bNIuWFNgNULLłB");
	return pLockObject;
}

void LockManager::RemoveUnusedLock()
{
	EnterCriticalSection(&criticalSect_);
	try {
		for (critical_section_map::iterator ite = criticalSections_.begin();
			ite != criticalSections_.end();) {
			CRITICAL_SECTION* pCriticalSect = ite->second;
			if (TryEnterCriticalSection(pCriticalSect)) {
				// bNmۂłƂƂ́AgĂȂƂƂƂ݂ȂB
				::LeaveCriticalSection(pCriticalSect);
				::DeleteCriticalSection(pCriticalSect);
				delete pCriticalSect;
				ite = criticalSections_.erase(ite);
				continue;
			}
			++ite;
		}
	}
	catch (...) {
		LeaveCriticalSection(&criticalSect_);
		throw;
	}
	LeaveCriticalSection(&criticalSect_);
}

