#include "stdafx.h"

#include "resource.h"
#include "ImpersonateUser.hpp"

#include <assert.h>


CImpersonateUser::CImpersonateUser()
	: userToken_(NULL)
	, bImpersonate_(false)
	, pLogger_(NULL)
{
}

/*!
 * UĂ΋UAOIĂ΃OIt܂B
 * łȂΉ܂B
 */
CImpersonateUser::~CImpersonateUser() throw()
{
	revertToSelf();
	logoff();
}

	/*!
 * OI܂B
 * łɃOIĂĂ͂Ȃ܂B
 * OCɎsꍇCImpersonateUserExceptionO܂B
 * \param userName [U
 * \param domain hCA
 * \param password pX[hA
 */
void CImpersonateUser::logon(const tstring& user, const tstring& domain, const tstring& password)
{
	assert( !userToken_ && "łɃOIĂ܂B");
	assert( !bImpersonate_ && "łɋUĂ܂B");

	if (userToken_ || user.empty()) {
		::SetLastError(ERROR_BAD_ARGUMENTS);
		throw CImpersonateUserException(ERROR_BAD_ARGUMENTS);
	}

	bImpersonate_ = false;

	DWORD dwLogonType = LOGON32_LOGON_INTERACTIVE;
	DWORD dwLogonProvider = LOGON32_PROVIDER_DEFAULT;
	//if (info_.impersonateDomain_.empty()) {
	//	dwLogonType = LOGON32_LOGON_NEW_CREDENTIALS;
	//	dwLogonProvider = LOGON32_PROVIDER_WINNT50;
	//}

	if ( !LogonUser(
		user.c_str(),
		domain.c_str(),
		password.c_str(),
		dwLogonType,
		dwLogonProvider,
		&userToken_)) {
		// OCɎs
		userToken_ = NULL;

		// OCs̃O
		DWORD err = GetLastError();
		if (pLogger_) {
			pLogger_->LogMessage(0, NULL, err, IDS_LOGMES_IMPERSONATE_LOGIN_FAILED, user.c_str(), domain.c_str());
		}
		throw CImpersonateUserException(err);
	}

	assert(userToken_ && "OI[UnhnullłB");

	// OCɐ
	user_ = user;
	domain_ = domain;

	if (pLogger_) {
		pLogger_->LogMessage(10, NULL, 0, _T("logonUser succeeded"));
	}
}

void CImpersonateUser::impersonate()
{
	assert(userToken_ && "OIĂ܂B");
	assert( !bImpersonate_ && "łɋUĂ܂B");

	if ( !userToken_ || bImpersonate_) {
		::SetLastError(ERROR_BAD_ARGUMENTS);
		throw CImpersonateUserException(ERROR_BAD_ARGUMENTS);
	}

	if ( !ImpersonateLoggedOnUser(userToken_)) {
		DWORD err = GetLastError();
		// Us̃O
		if (pLogger_) {
			pLogger_->LogMessage(0, NULL, err, IDS_LOGMES_IMPERSONATE_FAILED, user_.c_str(), domain_.c_str());
		}
		throw CImpersonateUserException(err);
	}

	bImpersonate_ = true;

	// ŨO
	if (pLogger_) {
		pLogger_->LogMessage(4, NULL, 0, IDS_LOGMES_IMPERSONATE, user_.c_str(), domain_.c_str());
	}
}

bool CImpersonateUser::revertToSelf() throw()
{
	if ( !userToken_ || !bImpersonate_) {
		::SetLastError(NO_ERROR);
		return false;
	}

	bImpersonate_ = false;

	if ( !::RevertToSelf()) {
		// UɎs
		DWORD err = ::GetLastError();
		if (pLogger_) {
			pLogger_->LogMessage(0, NULL, err, IDS_LOGMES_IMPERSONATE_REVERT_FAILED, user_.c_str(), domain_.c_str());
		}
		::SetLastError(err);
		return false;
	}

	// ŨO
	if (pLogger_) {
		pLogger_->LogMessage(4, NULL, 0, IDS_LOGMES_IMPERSONATE_REVERT, user_.c_str(), domain_.c_str());
	}
	return true;
}

bool CImpersonateUser::logoff() throw()
{
	// OIĂȂΉȂB
	if (!userToken_) {
		return true;
	}

	// UB(UĂ΁B)
	revertToSelf();

	if (!CloseHandle(userToken_)) {
		// OItɎsB
		return false;
	}

	userToken_ = NULL;
	if (pLogger_) {
		pLogger_->LogMessage(10, NULL, 0, _T("logonUser closed"));
	}
	return true;
}
