#pragma once

#include <exception>
#include <string>


/*!
 * IuWFNg̓ǂݏ̗O
 */
class CObjectReaderWriterException
	: public std::exception
{
private:
	DWORD errcode_;

public:
	CObjectReaderWriterException(DWORD errcode)
		: errcode_(errcode)
	{
	}

	DWORD GetErrorCode() const
	{
		return errcode_;
	}
};


/*!
 * IuWFNg̓ǂݍ݁B
 * oCif[^̃|[^reB(ACgoCgI[_[)͍lĂ܂B
 */
class CObjectReader
{
private:

	/*!
	 * t@Cnh
	 */
	HANDLE hFile_;

	CObjectReader(const CObjectReader&); //<! Ȃ
	CObjectReader& operator=(const CObjectReader&); //<! Ȃ

public:
	/*!
	 * t@Cnhw肵č\zB
	 * ̃NXg̓nh̃I[vуN[Y͏ȂB
	 */
	CObjectReader(HANDLE hFile);

	/*!
	 * t@Č݈ʒuDWORDǂݍށB
	 * ǂݍ݂sAǂݍ񂾌ʃTCYvȂΗOX[B
	 * \return ǂݍ܂ꂽDWORD
	 */
	DWORD ReadDWORD();

	/*!
	 * t@Č݈ʒuboolǂݍށB
	 * ǂݍ݂sAǂݍ񂾌ʃTCYvȂΗOX[B
	 * \return ǂݍ܂ꂽbool
	 */
	bool ReadBool();

	/*!
	 * t@Č݈ʒuunsigned __int64ǂݍށB
	 * ǂݍ݂sAǂݍ񂾌ʃTCYvȂΗOX[B
	 * \return ǂݍ܂ꂽunsigned __int64
	 */
	unsigned __int64 ReadInt64();

	/*!
	 * t@Č݈ʒuFILETIMEǂݍށB
	 * ǂݍ݂sAǂݍ񂾌ʃTCYvȂΗOX[B
	 * \param ǂݍ܂ꂽFILETIME̊i[
	 */
	void ReadFILETIME(FILETIME &value);

	/*!
	 * t@Č݈ʒutstringǂݍށB
	 * ͎s̃vZXUNICODEłUNICODEŊi[ĂȂ΂Ȃ炸A
	 * MBCSłMBCSŊi[ĂȂ΂Ȃ܂B
	 * vȂꍇ͗OX[܂B
	 * ǂݍ݂sAǂݍ񂾌ʃTCYvȂΗOX[B
	 * \param ǂݍ܂ꂽ̊i[
	 */
	void ReadString(tstring& value);

	/*!
	 * Cӂ̃oCgǂݍ݂܂B
	 * ǂݍ݂sAǂݍ񂾌ʃTCYvȂΗOX[B
	 * \param pBuf ǂݍ܂ꂽoCg̊i[
	 * \param siz i[TCY
	 */
	void ReadBytes(void *pBuf, size_t siz);

	/*!
	 * DWORDō\鎯ʎqv邩mF܂B
	 * DWORDǂ݂ƂȂAvȂꍇ͗OX[܂B
	 */
	void VerifySig(DWORD sig);

	/*!
	 * GUIDō\鎯ʎqv邩mF܂B
	 * GUIDǂݎȂAvȂꍇ͗OX[܂B
	 */
	void VerifySig(const GUID &sig);
};


/*!
 * IuWFNg̏݁B
 * oCif[^̃|[^reB(ACgoCgI[_[)͍lĂ܂B
 */
class CObjectWriter
{
private:

	/*!
	 * t@Cnh
	 */
	HANDLE hFile_;

	CObjectWriter(const CObjectReader&); //<! Ȃ
	CObjectWriter& operator=(const CObjectReader&); //<! Ȃ

public:
	/*!
	 * t@Cnhw肵č\z܂B
	 * ̃NX̓t@C̃I[vAN[Y̏͂܂B
	 */
	CObjectWriter(HANDLE hFile);

	/*!
	 * DWORD݂܂B
	 * ݂ɎsƗOX[܂B
	 * \param value ݒl
	 */
	void WriteDWORD(DWORD value);

	/*!
	 * bool݂܂B
	 * ݂ɎsƗOX[܂B
	 * \param value ݒl
	 */
	void WriteBool(bool value);

	/*!
	 * unsigned __int64݂܂B
	 * ݂ɎsƗOX[܂B
	 * \param value ݒl
	 */
	void WriteInt64(unsigned __int64 value);

	/*!
	 * DWORD݂܂B
	 * ݂ɎsƗOX[܂B
	 * \param value ݒl
	 */
	void WriteFILETIME(const FILETIME &value);

	/*!
	 * ݂܂B
	 * ݂̃vZXUNICODEłUNICODEŊi[܂B
	 * MBCSłMBCSŊi[܂B
	 * ݂ɎsƗOX[܂B
	 * \param value ݒl
	 */
	void WriteString(const tstring& value);

	/*!
	 * oCgf[^݂܂B
	 * ݂ɎsƗOX[܂B
	 * \param pBuf ݃f[^̃|C^
	 * \param siz ݃TCY
	 */
	void WriteBytes(const void *pBuf, size_t siz);

	/*!
	 * DWORDō\鎯ʎq݂܂B
	 * ݂ɎsƗOX[܂B
	 */
	void WriteSig(DWORD sig);

	/*!
	 * GUIDō\鎯ʎq݂܂B
	 * ݂ɎsƗOX[܂B
	 */
	void WriteSig(const GUID &sig);
};
