#pragma once

#include <Wincrypt.h>

#include <memory>
#include <string>
#include <map>
#include <exception>


/*!
 * ÍEÍ̎sO
 */
class CCryptException
	: public std::exception
{
private:
	DWORD errorcode_;

public:
	CCryptException(DWORD errorcode);

	DWORD GetErrorCode() const;
};


class CCryptPassword;


/*!
 * pX[hx[ẌÍEÍ̂߂̃NX
 */
class CCrypt
{
public:
	/*!
	 * ASYƃASYID̃}bv^
	 */
	typedef std::map<ALG_ID, tstring> algtypemap;

	/*!
	 * ASYƃASYID̃yA
	 */
	typedef algtypemap::value_type algtype;

protected:
	friend class CCryptPassword;

	/*!
	 * ÍpX[h
	 */
	class CCryptPassword
	{
		friend class CCrypt;
	private:

		/*!
		 * e
		 */
		CCrypt &crypt_;

		/*!
		 * pX[h̃nbV
		 */
		HCRYPTHASH hPasswordHash_;

		/*!
		 * pX[hx[X̑Ώ̈ÍL[
		 */
		HCRYPTKEY hPasswordKey_;

		/*!
		 * ÍɎgpASY
		 */
		tstring algName_;


		CCryptPassword(const CCryptPassword&); //<! Ȃ

		CCryptPassword& operator=(const CCryptPassword&); //<! Ȃ

	public:

		CCryptPassword(CCrypt &crypt);

		~CCryptPassword() throw();

		/*!
		 * pX[hݒ肵܂B
		 * ̏ꍇ̓pX[h܂B
		 * pX[hݒ肳ÍɎgꍇtrueԂ܂B
		 * \return Í̃pX[hꂽꍇtrue
		 */
		bool setPassword(const CCrypt::algtype &algtyp, const tstring& password);

		/*!
		 * pX[h܂B
		 */
		void clearPassword();

	private:

		/*!
		 * AvoC_̃nh擾܂B
		 * łɏς݂ł΁ÃnhԂ܂B
		 */
		HCRYPTPROV init();

		/*!
		 * pX[hx[X̃nbV𐶐ĕԂ܂B
		 * \param hProv voC_̃nh
		 * \param password pX[h
		 * \return nbV
		 */
		HCRYPTHASH createHash(HCRYPTPROV hProv, const tstring& password);

		/*!
		 * nbVΏ̈ÍL[𐶐܂B
		 * \param hProv voC_̃nh
		 * \param hHash nbV
		 * \param alg ASY
		 * \return ÍL[
		 */
		HCRYPTKEY createKey(HCRYPTPROV hProv, HCRYPTHASH hHash, const CCrypt::algtype &alg);
	};

private:

	/*!
	 * ÍvoC_
	 */
	HCRYPTPROV hProv_;

	/*!
	 * T|[gÍASỸ}bv
	 */
	algtypemap algtypemap_;


	CCrypt(const CCrypt&); //<! Ȃ

	CCrypt& operator=(const CCrypt&); //<! Ȃ

public:

	/*!
	 * ɉ܂B
	 */
	CCrypt();

	/*!
	 * ÍvoC_ĂΏ܂B
	 * pX[hnbVAΏ̈ÍL[쐬ĂΉ܂B
	 */
	~CCrypt() throw();

	/*!
	 * p\ȈÍASY̒D悷ASYIB
	 * płÍYɊYȂꍇ͗OB
	 * \return ASY
	 */
	const algtype& chooseAlgorithm();

	/*!
	 * w肵ÖÍASYT|[gĂ钆擾B
	 * YȂꍇ͗OB
	 * \param ASY
	 * \return ASY
	 */
	const algtype& findAlgorithm(const tstring& algName);

	/*!
	 * pX[hݒ肳Ă΁ÃpX[hx[ẌÍs܂B
	 * pX[hݒ肳ĂȂꍇ͕̂܂ܕԂ܂B
	 * \param src Í镶
	 * \param result Íꂽ
	 */
	void encrypt(const tstring& password, const algtype& algtyp, const tstring& src, tstring& result);

	/*!
	 * pX[hݒ肳Ă΁ÃpX[hňÍ܂B
	 * pX[hݒ肳ĂȂ΁Â܂ܕԂ܂B
	 */
	void decrypt(const tstring& password, const tstring& src, tstring& result);

private:

	/*!
	 * voC_܂B
	 * łɏς݂łΉ܂B
	 */
	void init();

	/*!
	 * T|[gĂASŸꗗ擾܂B
	 */
	void loadSupportedAlgorithm();
};

