#pragma once

#include "WatchThread.hpp"
#include "SettingInfo.hpp"

#include <string>
#include <vector>

class CWatchThreadGroup
{
private:
	/*!
	 * hC[h
	 */
	const bool dryrun_;

	/*!
	 * ύXtO
	 */
	mutable bool modified_;

	/*!
	 * ĎXbh̃Xg
	 */
	typedef std::vector<CWatchThread*> CWatchThreadList;
	CWatchThreadList watchList_;

private:
	CWatchThreadGroup( const CWatchThreadGroup& ); //<! Ȃ
	CWatchThreadGroup& operator=( const CWatchThreadGroup& ); //<! Ȃ

public:
	
	/*!
	 * ĎXbhO[v\z܂B
	 * hC[hLɂƃXbh͎ۂɂ͍쐬ꂸҏŴ݂ƂȂ܂B
	 * \param v_dryrun hC[h̏ꍇAtrue
	 */
	CWatchThreadGroup(const bool v_dryrun);

	virtual ~CWatchThreadGroup();
	
	void ReleaseAllThreads();

	unsigned int size() const;


	const CSettingInfo& getInfo( unsigned int idx ) const;


	bool append( const CSettingInfo& v_settingInfo );

	bool replace( unsigned int idx, const CSettingInfo& v_settingInfo );

	bool erase( unsigned int idx );


	bool isRunning() const;

	bool isDryrRun() const;


	bool LoadInfData( const tstring& InfPath );

	bool SaveInfData( const tstring& InfPath, bool bForce = false ) const;

	bool isModified() const;

protected:
	void ClearLog(const CSettingInfo& settingInfo) const;
};
