#include "stdafx.h"

#include "FileInfo.hpp"

#include "Utility.hpp"


CFileInfo::CFileInfo( const WIN32_FIND_DATA& v_finddata, bool v_modified, bool v_exists )
	: name_ ( v_finddata.cFileName )
	, writetime_( v_finddata.ftLastWriteTime )
	, size_( v_finddata.nFileSizeLow )
	, bExist_( v_exists )
	, detectModified_( v_modified )
	, tickcount_( 0 )
	, deletePending_( false )
	, deleteBeginTickCount_( 0 )
{
}

CFileInfo::CFileInfo( const CFileInfo& v_other )
	: name_( v_other.name_ )
	, writetime_( v_other.writetime_ )
	, bExist_( v_other.bExist_ )
	, detectModified_( v_other.detectModified_ )
	, tickcount_( v_other.tickcount_ )
	, size_( v_other.size_ )
	, deletePending_( v_other.deletePending_ )
	, deleteBeginTickCount_( v_other.deleteBeginTickCount_ )
{
}

CFileInfo& CFileInfo::operator=( const CFileInfo& v_other )
{
	if( this == &v_other ) {
		return *this;
	}

	name_ = v_other.name_;
	writetime_ = v_other.writetime_;
	bExist_ = v_other.bExist_;
	detectModified_ = v_other.detectModified_;
	tickcount_ = v_other.tickcount_;
	size_ = v_other.size_;
	deletePending_ = v_other.deletePending_;
	deleteBeginTickCount_ = v_other.deleteBeginTickCount_;

	return *this;
}

CFileInfo::~CFileInfo()
{
}


tstring CFileInfo::str() const
{
	SYSTEMTIME systime = {0};
	FILETIME localtime = {0};
	FileTimeToLocalFileTime(&writetime_, &localtime);
	FileTimeToSystemTime(&localtime, &systime);
	return ToString(
		_T("%s%s %04d/%02d/%02d %02d:%02d:%02d.%03d (%I64d)"),
		(detectModified_ ? _T("*") : _T("_")),
		(deletePending_ ? _T("$") : _T("_")),
		systime.wYear,
		systime.wMonth,
		systime.wDay,
		systime.wHour,
		systime.wMinute,
		systime.wSecond,
		systime.wMilliseconds,
		(__int64) size_
		);
}



void CFileInfo::update( const WIN32_FIND_DATA& v_finddata )
{
	name_  = v_finddata.cFileName;
	writetime_ = v_finddata.ftLastWriteTime;
	size_ = v_finddata.nFileSizeLow;
}

void CFileInfo::setExist( bool v_exist )
{
	bExist_ = v_exist;
}

void CFileInfo::setDeletePending( bool v_deletePending ) 
{
	deletePending_ = v_deletePending;
}

void CFileInfo::setDeleteBeginTickCount( DWORD v_tickcount )
{
	deleteBeginTickCount_ = v_tickcount;
}

void CFileInfo::setDetectModified( bool v_detectModified )
{
	detectModified_ = v_detectModified;
}

void CFileInfo::setFileName( const tstring& v_fileName )
{
	name_ = v_fileName;
}

void CFileInfo::setLastModified( const FILETIME& v_filetime )
{
	writetime_ = v_filetime;
}

void CFileInfo::setCountdownTickCount( DWORD v_tickcount )
{
	tickcount_ = v_tickcount;
}

void CFileInfo::setSize(unsigned __int64 v_size)
{
	size_ = v_size;
}
