// FWatch.cpp : AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.h"
#include "FWatchApp.hpp"
#include "resource.h"

#include "FWatchUI.hpp"
#include "ServiceEntry.hpp"
#include "Utility.hpp"

#include <assert.h>
#include <vector>


#include <strsafe.h>
#pragma comment(lib, "strsafe.lib")



LPCTSTR ResourceAccessor::getApplicationName() const
{
	return NULL;
}

HWND ResourceAccessor::getMainHWnd() const
{
	return NULL;
}

int ResourceAccessor::LoadString(UINT uMessageID, LPTSTR buffer, int nBufferMax) const
{
	return ::LoadString(getInstanceHandle(), uMessageID, buffer, nBufferMax);
}

tstring ResourceAccessor::LoadString(UINT uMessageID) const
{
	TCHAR buffer[4096] = {0};
	::LoadString(getInstanceHandle(), uMessageID, buffer, 4096);
	return buffer;
}

int ResourceAccessor::LoadInteger(UINT uMessageID) const
{
	return atoi(LoadString( uMessageID ).c_str());
}

tstring ResourceAccessor::LoadStringFormat(UINT uMessageID, ...) const
{
	va_list marker;
	va_start(marker, uMessageID);

	return LoadStringFormatV(uMessageID, marker);
}

tstring ResourceAccessor::LoadStringFormatV(UINT uMessageID, va_list marker) const
{
	const tstring format = LoadString(uMessageID);
	return ToStringV(format.c_str(), marker);
}

int ResourceAccessor::showMessageBox(UINT uType, LPCTSTR caption, UINT uMessageID, ...) const
{
	va_list marker;
	va_start(marker, uMessageID);

	const tstring message = LoadStringFormatV(uMessageID, marker);

	if (caption == NULL) {
		caption = getApplicationName();
	}

	return ::MessageBox(NULL, message.c_str(), caption, uType);
}

//////////////////////////


bool Configuration::IsDeleteLog() const
{
	return GetLong(_T("CONFIG"), _T("DELETELOG"), 0) != 0;
}

bool Configuration::IsRotateLog() const
{
	return GetLong(_T("CONFIG"), _T("ROTATELOG"), 1) != 0;
}

bool Configuration::IsCurrentDirSetToWatchDir() const
{
	return GetLong(_T("CONFIG"), _T("CURDIRECTORY"), 1) != 0;
}

long Configuration::GetLogCloseSpan() const
{
	return GetLong(_T("CONFIG"), _T("LOGCLOSESPAN"), 10);
}

tstring Configuration::GetString(LPCTSTR appName, LPCTSTR name, LPCTSTR defValue) const
{
	assert(appName && name && "appName, namenull͎wł܂B");

	int bufsiz = 1024;
	std::vector<TCHAR> buf(bufsiz);
	::GetPrivateProfileString(appName, name, defValue, &buf[0], bufsiz, getIniPath());
	return tstring(&buf[0]);
}

long Configuration::GetLong(LPCTSTR appName, LPCTSTR name, int defValue) const
{
	tstring value = GetString(appName, name, _T(""));
	if (value.length() > 0) {
		return _tstol(value.c_str());
	}
	return defValue;
}


///////////////////////////



FWatchApp::FWatchApp()
	: hMainWnd_( NULL )
	, cl_( false )
{
	hInstance_ = ::GetModuleHandle(NULL);
	applicationName_ = app.LoadString(IDS_APP_TITLE);

	GetBaseFileNameWithExtention(szHelpFile_, _T("hlp"), MAX_PATH);
	GetBaseFileNameWithExtention(IniPath_, _T("ini"), MAX_PATH);
}

FWatchApp::~FWatchApp()
{
}

HINSTANCE FWatchApp::getInstanceHandle() const
{
	//required:
	assert(hInstance_ != NULL && "܂Ă܂B");
	
	//do:
	return hInstance_;
}

LPCTSTR FWatchApp::getApplicationName() const
{
	return applicationName_.c_str();
}

HWND FWatchApp::getMainHWnd() const
{
	return hMainWnd_;
}

CWatchThreadGroup& FWatchApp::getCL()
{
	return cl_;
}

int FWatchApp::run(HINSTANCE, LPCTSTR v_lpCmdLine)
{
	//required:
	assert(v_lpCmdLine != NULL && "v_lpCmdLinenull͎wł܂B");

	//do:

	// p[^[̎擾
	const int cmdLineBufSiz = lstrlen(v_lpCmdLine) + 1;
	std::vector<TCHAR> cmdLineBuf(cmdLineBufSiz);
	_tcscpy_s(&cmdLineBuf[0], cmdLineBufSiz, v_lpCmdLine);

	const int argvMx = 16;
	LPTSTR argv[argvMx];
	const int argc = GetCmdArgs(&cmdLineBuf[0], argv, argvMx);

	// N[h̉

	enum CMDTYPE
	{
		CMDTYPE_NONE     = 0,
		CMDTYPE_REGIST   = 1,
		CMDTYPE_UNREGIST = 2,
		CMDTYPE_NORMAL   = 3,
		CMDTYPE_SERVICE  = 4,
		CMDTYPE_UNKNOWN  = 9
	} cmdtyp = CMDTYPE_NONE;

	int idx;
	for (idx = 0 ; idx < argc ; idx++) {
		if (argv[idx][0] == '/') {
			if ( !_tcsicmp(argv[idx], _T("/service")))			cmdtyp = CMDTYPE_REGIST;
			else if ( !_tcsicmp(argv[idx], _T("/unregister")))	cmdtyp = CMDTYPE_UNREGIST;
			else if ( !_tcsicmp(argv[idx], _T("/noservice")))	cmdtyp = CMDTYPE_NORMAL;
			else if ( !_tcsicmp(argv[idx], _T("/runservice")))	cmdtyp = CMDTYPE_SERVICE;
			else{
				showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_OPTION_FAIL, argv[idx]);
				return 1;
			}
		}
	}

	// t@C̃pX擾܂
	InfPath_[0] = 0;
	for (idx=0; idx < argc; idx++) {
		if (argv[idx][0] != '/') {
			// ŏ/ȊOł͂܂t@C̃pXƂ
			if ( !GetToken(InfPath_, argv[idx], MAX_PATH)) {
				showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_OPTION_INVALID);
				return 1;
			}
			break;
		}
	}
	if ( !InfPath_[ 0 ]) {
		// w肪Ȃꍇ̓fBtHg̃pX쐬
		GetBaseFileNameWithExtention(InfPath_, _T("lst"), MAX_PATH);
	}

	// p[^[`FbNAT[rXƂēo^邩܂B
	if (cmdtyp == CMDTYPE_REGIST) {
		// T[rXƂēo^ďI
		return RegistService();
	}
	else if (cmdtyp == CMDTYPE_UNREGIST) {
		// T[rX̓o^ďI
		return UnregistService();
	}

	// T[rX̏
	ServiceInit();

	BOOL bStartService = FALSE;
	const BOOL bRegistService = IsRegistService(bStartService);

	if (cmdtyp == CMDTYPE_SERVICE) {
		// T[rXvZX̋N̏ꍇ (T[rXo^ɐݒ肳)
		if ( !bRegistService) {
			// T[rXƂēo^ĂȂꍇ
			app.showMessageBox(MB_SERVICE_NOTIFICATION | MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_SERVICENOREG);
		}
		else if (bStartService) {
			// T[rXɎsĂꍇ
			app.showMessageBox(MB_SERVICE_NOTIFICATION | MB_ICONERROR | MB_OK, NULL, IDS_SERVICE_RUNNING);
		}
		else if ( !StartService()) {
			// T[rXNłȂꍇ
			app.showMessageBox(MB_SERVICE_NOTIFICATION | MB_ICONERROR | MB_OK, NULL, IDS_SERVICE_STARTERROR);
		}
	}
	else {
		// T[rXvZXƂċNĂȂꍇ (ʏ̃vZXƂĎs)
		FWatchUI ui;
		if ( !ui.create()) {
			// UI̍\zɎs
			app.showMessageBox(MB_ICONERROR, NULL, IDS_UI_CREATIONFAILED);
		}
		else {
			// X^hAŊĎ̊Jn
			cl_.LoadInfData(InfPath_);

			// bZ[W[v
			MSG msg;
			while (GetMessage(&msg, NULL, 0, 0)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}

			// ĎI
			cl_.ReleaseAllThreads();
		}
	}

	return 0;
}

LPCTSTR FWatchApp::getInfPath() const
{
	return InfPath_;
}

LPCTSTR FWatchApp::getIniPath() const
{
	return IniPath_;
}

void FWatchApp::showHelp( HWND hWnd ) const
{
	::WinHelp(hWnd, szHelpFile_, HELP_CONTENTS, 0);
}

FWatchApp app;


/*!
 * Gg|Cg
 * \param hInstance CX^X
 * \return IR[h
 */
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int)
{
	// fobOtO(_DEBUĜݗL)
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	// ^C̏ݒ
	setlocale(LC_ALL, "");

	// COM̏
	if (FAILED(::CoInitializeEx(NULL, COINIT_APARTMENTTHREADED))) {
		app.showMessageBox(MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_COINITFAILED);
		return 1;
	}

	// R}hC̎擾
	LPCTSTR lpCmdLine = GetCommandLine();
	lpCmdLine = GetToken(NULL, lpCmdLine, 0); // ŏ̗vf(st@C)ǂݔ΂.

	// C
	const int result = app.run(hInstance, lpCmdLine);

	// COM̏
	::CoUninitialize();
	return result;
}
