#include "stdafx.h"
#include "resource.h"
#include "FWatchApp.hpp"
#include "ActionInvoker.hpp"

#include <vector>

#include <assert.h>

#include "Utility.hpp"
#include "StringExpander.hpp"


#include <strsafe.h>
#pragma comment(lib, "strsafe.lib")


ActionInvoker::ActionInvoker(const CSettingInfo& v_settingInfo) throw()
	: settingInfo_(v_settingInfo)
	, pLogger_(NULL)
{
}

ActionInvoker::~ActionInvoker() throw()
{
	// ێĂSẴvZXnh
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end();
		++ite ) {
		HANDLE hProcess = *ite;
		::CloseHandle(hProcess);
	}
	processHandleList_.clear();
}

unsigned int ActionInvoker::sweepTerminatedProcess() throw()
{
	unsigned int count = 0;
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end();) {
		HANDLE hProcess = *ite;
		const DWORD ret = ::WaitForSingleObject(hProcess, 0);
		if (ret != WAIT_TIMEOUT) {
			// vZXIĂȂƂmłȂΏIĂƂ݂ȂB

			// vZXnh
			DWORD err = 0;
			if ( !::CloseHandle(hProcess)) {
				err = GetLastError();
			}

			// ĎXgO
			ite = processHandleList_.erase( ite );

			// O
			if (pLogger_) {
				pLogger_->LogMessage(
					2,
					NULL,
					err,
					IDS_LOGMES_WATCHPROC_END,
					processHandleList_.size(),
					settingInfo_.getMaxProcess()
					);
			}
		}
		else {
			count++;
			++ite;
		}
	}
	return count;
}

void ActionInvoker::addTraceProcessHandle( HANDLE v_hProcess ) throw()
{
	if (v_hProcess == NULL) {
		return;
	}
	if (settingInfo_.getMaxProcess() <= 0) {
		// Ȃ̂ŒǐՂ̕KvȂ̂ŁAɃnh
		::CloseHandle( v_hProcess );
	}
	else {
		processHandleList_.push_back(v_hProcess);

		// O
		if (pLogger_) {
			pLogger_->LogMessage(
				2,
				NULL,
				0,
				IDS_LOGMES_WATCHPROC,
				processHandleList_.size(),
				settingInfo_.getMaxProcess()
				);
		}
	}
}

//////////

ActionInvokerFactory::ActionInvokerFactory(const CSettingInfo& v_settingInfo )
	: settingInfo_(v_settingInfo)
{
}

ActionInvokerFactory::~ActionInvokerFactory()
{
}

ActionInvokerPtr ActionInvokerFactory::create() const
{
	return ActionInvokerPtr(new ShellExecActionInvoker(settingInfo_ ));
}

//////////


ShellExecActionInvoker::ShellExecActionInvoker(const CSettingInfo& v_settingInfo) throw()
	: ActionInvoker( v_settingInfo )
	, executeCount_(0)
{
}

ShellExecActionInvoker::~ShellExecActionInvoker() throw()
{
}

bool ShellExecActionInvoker::createProcess(const tstring& v_absolutePath, const CFileInfo&) throw()
{
	//required:
	assert( !v_absolutePath.empty() && "v_absolutePathɋ͎wł܂B");
	
	//do:

	// s񐔂JEg
	executeCount_++;

	// NAvP[Vw肳ĂȂΉȂ.
	if (settingInfo_.getAppName().empty()) {
		return true;
	}

	// sp[^̍쐬
	tstring dirname = GetDirName(v_absolutePath);
	tstring basename = GetBaseName(v_absolutePath);
	tstring namebody = GetNameBody(v_absolutePath);

	TCHAR szShortPath[MAX_PATH] = {0};
	TCHAR szShortDirName[MAX_PATH] = {0};
	GetShortPathName(v_absolutePath.c_str(), szShortPath, MAX_PATH);
	GetShortPathName(dirname.c_str(), szShortDirName, MAX_PATH);

	SYSTEMTIME systime = {0};
	GetLocalTime(&systime);

	TCHAR szDate[9];
	TCHAR szTime[7];
	TCHAR szCount[10];
	
	HRESULT hr;

	hr = StringCbPrintf(
		szDate,
		sizeof(szDate),
		_T("%04d%02d%02d"),
		systime.wYear,
		systime.wMonth,
		systime.wDay
		);
	hr = StringCbPrintf(
		szTime,
		sizeof(szTime),
		_T("%02d%02d%02d"),
		systime.wHour,
		systime.wMinute,
		systime.wSecond
		);
	hr = StringCbPrintf(
		szCount,
		sizeof(szCount),
		_T("%d"),
		executeCount_
		);

	// sp[^̃Zbg
	PropertyStringExpander expander;
	LPCTSTR sec = _T("EXPAND_VAR_NAMES");
	expander.addProperty(app.GetString(sec, _T("PATH"), _T("PATH")), v_absolutePath);
	expander.addProperty(app.GetString(sec, _T("FULLPATH"), _T("FULLPATH")), v_absolutePath); // PATH GCAX
	expander.addProperty(app.GetString(sec, _T("DIR"), _T("DIR")), dirname);
	expander.addProperty(app.GetString(sec, _T("DIRNAME"), _T("DIRNAME")), dirname); // DIR GCAX
	expander.addProperty(app.GetString(sec, _T("NAME"), _T("NAME")), basename);
	expander.addProperty(app.GetString(sec, _T("BASENAME"), _T("BASENAME")), basename); // NAME GCAX
	expander.addProperty(app.GetString(sec, _T("NAMEBODY"), _T("NAMEBODY")), namebody);
	expander.addProperty(app.GetString(sec, _T("DATE"), _T("DATE")), szDate);
	expander.addProperty(app.GetString(sec, _T("TIME"), _T("TIME")), szTime);
	expander.addProperty(app.GetString(sec, _T("SPATH"), _T("SPATH")), szShortPath);
	expander.addProperty(app.GetString(sec, _T("SDIR"), _T("SDIR")), szShortDirName);
	expander.addProperty(app.GetString(sec, _T("COUNT"), _T("COUNT")), szCount);

	expander.addProperty(app.GetString(sec, _T("WATCHDIR"), _T("WATCHDIR")),
		EnsureLast(settingInfo_.getWatchDir(), _T("\\")));


	const tstring appName = expander.expandString(settingInfo_.getAppName());
	const tstring param = expander.expandString(settingInfo_.getParam());
	const tstring verb = expander.expandString(settingInfo_.getAction());

	SHELLEXECUTEINFO execinfo = {0};
	execinfo.cbSize = sizeof(SHELLEXECUTEINFO);
	execinfo.fMask  = SEE_MASK_CONNECTNETDRV | SEE_MASK_DOENVSUBST | SEE_MASK_NOCLOSEPROCESS;
	execinfo.hwnd   = NULL;
	execinfo.lpDirectory  = NULL; // : ܂FWatch.exeÑJg
	execinfo.nShow  = settingInfo_.getShowWindow().getShowCommand();
	execinfo.lpVerb = verb.c_str();
	execinfo.lpFile = appName.c_str();
	execinfo.lpParameters = param.c_str();

	tstring appCurrentDir = expander.expandString(settingInfo_.getAppCurrentDir());

	if ( !appCurrentDir.empty()) {
		// JgfBNg̎w肪ꍇ́Aݒ肷B
		execinfo.lpDirectory = appCurrentDir.c_str();

	} else {
		if (app.IsCurrentDirSetToWatchDir()) {
			// AvP[VÑJgfBNgĎΏۃtH_ɂ
			execinfo.lpDirectory = settingInfo_.getWatchDir().c_str();
		}
	}

	// O
	if (pLogger_) {
		pLogger_->LogMessage(
			2,
			NULL,
			0,
			IDS_LOGMES_APPLIC,
			verb.c_str(),
			appName.c_str(),
			param.c_str()
			);
	}

	// s
	DWORD err = ERROR_SUCCESS;
	if (ShellExecuteEx(&execinfo)) {
		addTraceProcessHandle(execinfo.hProcess);
	}
	else {
		err = GetLastError();
		if (pLogger_) {
			pLogger_->LogMessage(
				0,
				NULL,
				err,
				IDS_LOGMES_APPLICFAIL,
				appName.c_str()
				);
		}
	}

	return err == ERROR_SUCCESS;
}
