#pragma once

#include "SettingInfo.hpp"

#include <string>
#include <map>
#include <list>
#include <functional>

#include "FileInfo.hpp"

#include "ActionInvoker.hpp"
#include "Logger.hpp"

/*!
 * t@C̃^CX^vł邩肷֐IuWFNg
 */
class FileTimeComparator
	: public std::binary_function<FILETIME, FILETIME, bool>
{
private:
	long tolerance_;

public:
	FileTimeComparator(long v_tolerance)
		: tolerance_(v_tolerance)
	{
	}

	inline bool operator()(const FILETIME& a, const FILETIME& b) const
	{
		const __int64& t1 = *(__int64*) &a;
		const __int64& t2 = *(__int64*) &b;
		const __int64 distance = (t2 - t1) / 10000;
		return !((distance < -tolerance_) || (distance > tolerance_));
	}
};


/*!
 * ~Cxgɂ銄荞ݗpO
 */
class CWatchThreadInterruptedException : public std::exception
{
public:
	static void checkAndThrow(HANDLE hStopEvent);
};


/*!
 * 1̐ݒɑ΂ĎsĎ{(Xbh)B
 */
class CWatchThread
{
private:
	CWatchThread(const CWatchThread&); //<! Ȃ
	CWatchThread& operator=(const CWatchThread&); //<! Ȃ

private:

	typedef std::map<tstring, CFileInfo > CFileInfoMap;

	CFileInfoMap fileInfoMap_;

	typedef std::list<tstring> FileNameList;

	FileNameList pendingList_;

	LoggerPtr pLogger_;

	ActionInvokerPtr pActionInvoker_;

	const FileTimeComparator fileTimeComparator_;

	CSettingInfo settingInfo_;

	HANDLE hStopEvent_;

	HANDLE hThread_;

	DWORD nThreadID_;

	DWORD spanSweepDeletedEntries_;

	DWORD spanHeapCompaction_;

	DWORD logCloseSpan_;


public:

	CWatchThread(const CSettingInfo& v_settingInfo);

	virtual ~CWatchThread();

	const CSettingInfo& getSettingInfo() const;

	void Start();

	void Stop();

	void StopNoWait();

	bool isRunning() const;

private:

	void run();

	void sweepDeletedEntries();

	void EnumFile(const bool v_enableEvent);

	bool EnumFileRecursive(const tstring& v_baseDir, const int v_depth, const bool v_enableEvent);

	static bool getFileSize(const tstring& v_path, unsigned __int64 *pSize);

	static unsigned __stdcall CWatchThread::FWatchThread(void* pParam);
};
