#pragma once

#include <string>

/*!
 * EBhE\TCY
 */
class ShowWindowType {
private:
	/*!
	 * vCx[gRXgN^
	 * \param ID
	 */
	ShowWindowType( const int v_showWindowType );

public:

	/*!
	 * ftHglݒ肷ftHgRXgN^
	 */
	ShowWindowType();

	/*!
	 * Rs[RXgN^
	 * \param Rs[
	 */
	ShowWindowType( const ShowWindowType& v_other );

	/*!
	 * Rs[
	 * \param Rs[
	 */
	ShowWindowType& operator=( const ShowWindowType& v_other );

	/*!
	 * Ƃ肤l̈ꗗ
	 */
	enum member
	{
		MINIMIZED_NOACTIVE = 0,
		NORMAL = 1,
		MAXIMIZED = 2,
		HIDDEN = 3,
		MINIMIZED = 4
	};

	/*!
	 * int^ւ̕ϊIDԂ܂B
	 * \return ID
	 */
	operator int() const;

	/*!
	 * 擾܂B
	 * \return 
	 */
	tstring getDescription() const;

	/*!
	 * EBhEJR}hԂ܂B
	 * SW_SHOWNORMALȂǂ̒萔łB
	 * \param R}hID
	 */
	int getShowCommand() const;

	/*!
	 * IDw肵Ď擾܂B
	 * ͈͊Ȍꍇ̓ftHgԂ܂B
	 */
	static ShowWindowType valueOf( const int v_showWindowType );

	/*!
	 * ؂܂B
	 * \param rΏ
	 * \return true
	 */
	inline bool operator==( const ShowWindowType& v_other ) const
	{
		return v_other.showWindowType_ == showWindowType_;
	}

	/*!
	 * Ȃ؂܂B
	 * \param rΏ
	 * \return Ȃtrue
	 */
	inline bool operator!=( const ShowWindowType& v_other ) const
	{
		return v_other.showWindowType_ != showWindowType_;
	}

private:

	int showWindowType_;

};

/*!
 * Ďݒ
 */
class CSettingInfo {
	/**
	 * ݃ANZXł̂̓t@NgB
	 * t@Ng͕KԂ̃IuWFNgԂB
	 */
	friend class CSettingInfoFactory;

protected:

	tstring watchDir_;
	tstring watchFile_;
	tstring action_;
	tstring appName_;
	tstring param_;
	tstring log_;

	ShowWindowType showWindow_;

	int nWaitWrite_;
	int nTolerance_;
	
	unsigned int nMaxProcess_;

	int nDeletePending_;

	// ǉ

	int nMaxDepth_;
	int nForceInterval_;
	int nDirNotificationAPIRetryInterval_;
	int nDirNotificationAPIExpirySpan_;

	bool bUsingNotificationAPI_;

	int logLevel_;
	tstring appCurrentDir_;
	tstring persist_;

public:

	/*!
	 * LȃftHglŏꂽIuWFNg\z܂B
	 */
	CSettingInfo();

	/*!
	 * Rs[RXgN^
	 * \param v_other Rs[
	 */
	CSettingInfo( const CSettingInfo& v_other );

	/*!
	 * Rs[
	 * \param v_other Rs[
	 */
	CSettingInfo& operator=( const CSettingInfo& v_other );

	/*!
	 * fXgN^
	 */
	virtual ~CSettingInfo();

	/*!
	 * ĎfBNg擾܂B
	 * \return ĎfBNgւ̃pX
	 */
	inline const tstring& getWatchDir() const {
		return watchDir_;
	}

	/*!
	 * Ďt@C擾܂B
	 * \return Ďt@C̃p^[
	 */
	inline const tstring& getWatchFile() const {
		return watchFile_;
	}

	/*!
	 * ANV擾܂B
	 * \return ANV
	 */
	inline const tstring& getAction() const {
		return action_;
	}

	/*!
	 * ANVsvO擾܂B
	 * \return vO
	 */
	inline const tstring& getAppName() const {
		return appName_;
	}

	/*!
	 * ANVsvOɈnp[^擾܂B
	 * \return p[^
	 */
	inline const tstring& getParam() const {
		return param_;
	}

	/*!
	 * ȌݐpX擾܂B
	 * \return Ȍݐ
	 */
	inline const tstring& getLog() const {
		return log_;
	}

	/*!
	 * Ȍ݂w肳Ă邩擾܂B
	 * \return Ȍ݂w肳Ăꍇtrue
	 */
	inline bool isEnableLogging() const {
		return ! log_.empty();
	}

	/*!
	 * ĎΏۃt@C̏݊ҋ@܂ł̎Ԃ擾܂B
	 * \return ݊ҋ@
	 */
	inline int getWaitWrite() const {
		return nWaitWrite_;
	}

	/*!
	 * vZX̏I҂̗L擾܂B
	 * \return vZXI܂Ŏ̃vZXNȂꍇtrue
	 */
	inline unsigned int getMaxProcess() const {
		return nMaxProcess_;
	}

	/*!
	 * vZXNƂ̃EBhETCY
	 * \return EBhETCY
	 */
	inline ShowWindowType getShowWindow() const {
		return showWindow_;
	}

	/*!
	 * t@CłƂ݂Ȃ͈(x)擾܂B
	 * \return x(mSec)
	 */
	inline int getTolerance() const {
		return nTolerance_;
	}

	/*!
	 * t@C폜mĂGg폜鎞(100mSecP)擾܂B
	 * \return Gg폜܂ł̊(100mSec)
	 */
	inline int getDeletePending() const {
		return nDeletePending_;
	}

	/*!
	 * TufBNg𑀍삷ő̐[擾܂B
	 * 0Ŏw肵fBNĝ݂ΏۂƂ܂B
	 * \return ő̐[A0ȏ
	 */
	inline int getMaxDepth() const {
		return nMaxDepth_;
	}

	/*!
	 * ̊Ԋu(b)擾܂B
	 * 0̏ꍇ͋܂B
	 * 0̏ꍇ̓fBNgAPILłȂ΂Ȃ܂B
	 * \return Ԋu̕b
	 */
	inline int getForceInterval() const {
		return nForceInterval_;
	}

	/*!
	 * fBNgĎAPIɂĎg擾܂B
	 * gꍇ͋{̊Ԋu1ȏɂȂ΂Ȃ܂B
	 * \return fBNgĎAPIgꍇtrue
	 */
	inline bool isUsingDirNotificationAPI() const {
		return bUsingNotificationAPI_;
	}

	/*!
	 * fBNgĎAPI̍\zɎsꍇ̍ĎsԊu(b)B
	 * 0̏ꍇ͑s܂B
	 * \return Ďs̊Ԋu(b)
	 */
	inline int getDirNotificationAPIRetryInterval() const {
		return nDirNotificationAPIRetryInterval_;
	}

	/*!
	 * fBgNčAPI̗L(b)擾܂B
	 * w肵o߂ƁAfBNgčAPI͍č쐬܂B
	 * 0w肵ꍇ͍č쐬܂B
	 * fBNgčAPIgȂꍇ͈Ӗ܂B
	 * \return L(b)
	 */
	inline int getDirNotificationAPIExpirySpan() const {
		return nDirNotificationAPIExpirySpan_;
	}

	/*!
	 * Oȍ͎ڍדx擾܂B
	 * l傫قǏڍׂƂȂ܂B
	 */
	inline int getLogLevel() const {
		return logLevel_;
	}

	/*!
	 * AvP[Vs̃JgfBNgB
	 * ̏ꍇFWatch.ini̐ݒɂAĎtH_܂̓ftHg(FWatch̃fBNg)ƂȂB
	 */
	inline const tstring& getAppCurrentDir() const {
		return appCurrentDir_;
	}

	/*!
	 * it@C擾܂B
	 * w肳ĂȂꍇ͉i܂B
	 */
	inline const tstring& getPersist() const {
		return persist_;
	}
};
