#pragma once

#include <string>

class CFileInfo
{
private:
	tstring name_;
	FILETIME writetime_;
	unsigned __int64 size_;

	bool bExist_;
	bool detectModified_;
	DWORD tickcount_;

	bool deletePending_;
	DWORD deleteBeginTickCount_;


public:
	CFileInfo( const WIN32_FIND_DATA& v_finddata, bool v_modified, bool v_exists = true );
	
	CFileInfo( const CFileInfo& v_other );

	CFileInfo& operator=( const CFileInfo& v_other );

	~CFileInfo();


	inline const tstring& getFileName() const
	{
		return name_;
	}

	inline const FILETIME& getLastModified() const
	{
		return writetime_;
	}

	inline unsigned __int64 getSize() const
	{
		return size_;
	}

	inline bool isExist() const
	{
		return bExist_;
	}

	inline bool isDeletePending() const
	{
		return deletePending_;
	}

	inline DWORD getDeleteBeginTickCount() const
	{
		return deleteBeginTickCount_;
	}

	inline bool isDetectModified() const
	{
		return detectModified_;
	}

	inline DWORD getCountdownTickCount() const
	{
		return tickcount_;
	}


	void update(const WIN32_FIND_DATA& v_finddata);

	void setFileName(const tstring& v_fileName);

	void setLastModified(const FILETIME& v_filetime);

	void setDeletePending(bool v_deletePending);

	void setDeleteBeginTickCount(DWORD v_tickcount);

	void setCountdownTickCount(DWORD v_tickcount);

	void setSize(unsigned __int64 v_size);

	void setExist(bool v_exist);

	void setDetectModified(bool v_detectModified);

	/*!
	 * ff(O)p
	 */
	tstring str() const;
};
