#pragma once

#include "WatchThreadGroup.hpp"
#include "LockManager.hpp"

#include <string>
#include <vector>

#include <assert.h>


class ResourceAccessor
{
public:
	virtual ~ResourceAccessor() {};
	virtual HINSTANCE getInstanceHandle() const = 0;
	virtual LPCTSTR getApplicationName() const;
	virtual HWND getMainHWnd() const;

	int LoadString(UINT uMessageID, LPTSTR buffer, int nBufferMax) const;
	int LoadInteger(UINT uMessageID) const;

	tstring LoadString(UINT uMessageID) const;
	tstring LoadStringFormat(UINT uMessageID, ...) const;
	tstring LoadStringFormatV(UINT uMessageID, va_list marker) const;

	int showMessageBox(UINT uType, LPCTSTR caption, UINT uMessageID, ...) const;
};


class Configuration
{
public:
	virtual ~Configuration() = 0 {};

	bool IsDeleteLog() const;

	bool IsRotateLog() const;

	long GetLogCloseSpan() const;

	bool IsCurrentDirSetToWatchDir() const;

	tstring GetString(LPCTSTR appName, LPCTSTR name, LPCTSTR defValue) const;

	long GetLong(LPCTSTR appName, LPCTSTR name, int defValue) const;

	virtual LPCTSTR getIniPath() const = 0;
};


class FWatchApp
	: public ResourceAccessor
	, public Configuration
	, public LockManager
{
private:
	FWatchApp( const FWatchApp& ); //<! Ȃ
	FWatchApp& operator=(const FWatchApp& ); //<! Ȃ

public:
	FWatchApp();
	virtual ~FWatchApp();
	
	int run( HINSTANCE v_hInstance, LPCTSTR v_lpCmdLine );

	virtual HINSTANCE getInstanceHandle() const;
	virtual LPCTSTR getApplicationName() const;
	virtual HWND getMainHWnd() const;

	LPCTSTR getInfPath() const;
	virtual LPCTSTR getIniPath() const;

	void showHelp( HWND hWnd ) const;

	CWatchThreadGroup& getCL();

private:
	HINSTANCE hInstance_;
	HWND hMainWnd_;

	tstring applicationName_;

	TCHAR szHelpFile_[MAX_PATH];			// wvt@C̃pX
	TCHAR IniPath_[MAX_PATH];				// INIt@Cւ̃pX
	TCHAR InfPath_[MAX_PATH];				// LSTt@Cւ̃pX

	CWatchThreadGroup cl_;
};


/*!
 * O[oȃAvP[VCX^X
 */
extern FWatchApp app;
