#pragma once

#include "FileInfo.hpp"
#include "SettingInfo.hpp"

#include "Logger.hpp"

#include <string>
#include <list>
#include <memory>

class ActionInvoker
{
private:
	typedef std::list<HANDLE> ProcessHandleList;

	ProcessHandleList processHandleList_;

protected:

	Logger* pLogger_;

	const CSettingInfo& settingInfo_;

private:
	ActionInvoker( const ActionInvoker& ); //<! Ȃ
	ActionInvoker& operator=( const ActionInvoker& ); //<! Ȃ

public:
	ActionInvoker( const CSettingInfo& v_settingInfo ) throw();
	
	virtual ~ActionInvoker() throw();

	virtual bool createProcess(const tstring& v_absolutePath, const CFileInfo&) throw() = 0;

	virtual unsigned int sweepTerminatedProcess() throw();

	virtual inline unsigned int GetActiveProcessCount() throw()
	{
		return sweepTerminatedProcess();
	}

	virtual void SetLogger(Logger* pLogger) throw()
	{
		pLogger_ = pLogger;
	}

	virtual Logger* GetLogger() const throw()
	{
		return pLogger_;
	}

protected:
	virtual void addTraceProcessHandle(HANDLE v_hProcess) throw();
};


typedef std::auto_ptr<ActionInvoker> ActionInvokerPtr;


class ActionInvokerFactory
{
private:
	ActionInvokerFactory( const ActionInvokerFactory& ); //<! Ȃ
	ActionInvokerFactory& operator=( const ActionInvokerFactory& ); //<! Ȃ

private:
	const CSettingInfo& settingInfo_;

public:
	ActionInvokerFactory(const CSettingInfo& v_settingInfo);
	virtual ~ActionInvokerFactory();
	virtual ActionInvokerPtr create() const;
};


class ShellExecActionInvoker : public ActionInvoker
{
private:
	ShellExecActionInvoker(const ShellExecActionInvoker&); //<! Ȃ
	ShellExecActionInvoker& operator=(const ShellExecActionInvoker&); //<! Ȃ

private:
	int executeCount_;

public:
	ShellExecActionInvoker(const CSettingInfo& v_settingInfo) throw();

	virtual ~ShellExecActionInvoker() throw();

	virtual bool createProcess(const tstring& v_absolutePath, const CFileInfo&) throw();
};
