#include "stdafx.h"

#include "FWatchCore2Test.hpp"

#include "../include/FWatchCore2Obj.hpp"

void TestNameMatcher(void) throw()
{
	HRESULT hr;

	CComPtr<INameMatcherFactory> pNameMatcherFactory;
	hr = CreateNameMatcherFactoryObject(&pNameMatcherFactory);
	TEST(SUCCEEDED(hr));

	CComPtr<INameMatcher> pNameMatcher;

	hr = pNameMatcherFactory->Create(L"*.txt", &pNameMatcher);
	TEST(SUCCEEDED(hr));

	TEST(pNameMatcher->IsMatch(L".txt") == S_OK);
	TEST(pNameMatcher->IsMatch(L"1.txt") == S_OK);
	TEST(pNameMatcher->IsMatch(L"123.txt") == S_OK);
	TEST(pNameMatcher->IsMatch(L"123.txt.txt") == S_OK);

	TEST(pNameMatcher->IsMatch(L".txt.exe") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"1.txt.exe") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"123.txt.txtx") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"123.txt.txt.") == S_FALSE);

	pNameMatcher.Release();

	hr = pNameMatcherFactory->Create(L"abc*.txt", &pNameMatcher);
	TEST(SUCCEEDED(hr));

	TEST(pNameMatcher->IsMatch(L"abc.txt") == S_OK);
	TEST(pNameMatcher->IsMatch(L"abc1.txt") == S_OK);
	TEST(pNameMatcher->IsMatch(L"abc123.txt") == S_OK);
	TEST(pNameMatcher->IsMatch(L"abcabc123.txt.txt") == S_OK);

	TEST(pNameMatcher->IsMatch(L"abc.txt.exe") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"abc1.txt.exe.txt.exe") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"abc123.txt.txtx") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"abcabc123.txt.txt.") == S_FALSE);

	pNameMatcher.Release();

	hr = pNameMatcherFactory->Create(L"*a*b*c*", &pNameMatcher);
	TEST(SUCCEEDED(hr));

	TEST(pNameMatcher->IsMatch(L"aBc") == S_OK);
	TEST(pNameMatcher->IsMatch(L"aaAbbbcccddd") == S_OK);
	TEST(pNameMatcher->IsMatch(L"abcabc") == S_OK);
	TEST(pNameMatcher->IsMatch(L"1111a222B333c444") == S_OK);
	TEST(pNameMatcher->IsMatch(L"abdc") == S_OK);
	TEST(pNameMatcher->IsMatch(L"Xaabdcb") == S_OK);

	TEST(pNameMatcher->IsMatch(L"Def") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"aaaabd") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"ccccbbbbaaaa") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"abd") == S_FALSE);

	pNameMatcher.Release();

	hr = pNameMatcherFactory->Create(L"????.txt?", &pNameMatcher);
	TEST(SUCCEEDED(hr));

	TEST(pNameMatcher->IsMatch(L"AbcD.txt2") == S_OK);
	TEST(pNameMatcher->IsMatch(L"A.tXt") == S_OK);
	TEST(pNameMatcher->IsMatch(L".tXt2") == S_OK);
	TEST(pNameMatcher->IsMatch(L".txt") == S_OK);
	TEST(pNameMatcher->IsMatch(L"abd.txt") == S_OK);

	TEST(pNameMatcher->IsMatch(L"def") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"abcde.txt2") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"abcde.txt") == S_FALSE);
	TEST(pNameMatcher->IsMatch(L"abcd.tx2x") == S_FALSE);

	pNameMatcher.Release();
}
