#pragma once

#include "../include/FWatchCore2Obj.hpp"

typedef CComPtr<IFileInfo> IFileInfoPtr;

class FileInfoMap : public CAtlMap<CComBSTR, IFileInfoPtr>
{
public:
};

class __declspec(uuid("F571804D-AED6-4e82-BE42-65DB3AD5759A")) CFileInfoCollection
	: public IFileInfoCollection
	, public IFileInfoReceiver
	, public IPersistStreamInit
	, public CComObjectRoot
	, public CComCoClass<CFileInfoCollection, &__uuidof(CFileInfoCollection)>
{
public:
	friend class CFileInfoEnumerator;

	DECLARE_OBJECT_DESCRIPTION("CFileInfoCollection")
	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	BEGIN_COM_MAP(CFileInfoCollection)
		COM_INTERFACE_ENTRY(IFileInfoCollection)
		COM_INTERFACE_ENTRY(IFileInfoReceiver)
		COM_INTERFACE_ENTRY(IPersistStreamInit)
		COM_INTERFACE_ENTRY_IID(__uuidof(IPersistStream), IPersistStreamInit)
		COM_INTERFACE_ENTRY_IID(__uuidof(IPersist), IPersistStreamInit)
	END_COM_MAP()

	/// PRIVATE

	HRESULT FinalConstruct() throw();

	/// IFileInfoCollection

	HRESULT __stdcall get_Length(ULONG* v_pLength) throw();

	HRESULT __stdcall new_Enum(IFileInfoEnumerator** v_ppFileInfoEnumerator) throw();

	HRESULT __stdcall get_Item(LPCWSTR v_pName, IFileInfo** v_ppFindData) throw();

	HRESULT __stdcall set_Item(LPCWSTR v_pName, IFileInfo* v_pFileInfo) throw();

	HRESULT __stdcall remove_Item(LPCWSTR v_pName) throw();

	HRESULT __stdcall Clear() throw();

	HRESULT __stdcall Compare(IFileInfoCollection* v_pFileInfoCollection, IFileInfoComparator* v_pComparator) throw();

	HRESULT __stdcall Clone(IFileInfoCollection** v_ppClone) throw();

	/// IFileInfoReceiver

	HRESULT __stdcall ReceiveFileInfo(LPCWSTR v_pPath, IFileInfo* v_pFileInfo) throw();

	/// IPersist

	HRESULT __stdcall GetClassID(CLSID *pClassID) throw();

	/// IPersistStream

	HRESULT __stdcall IsDirty() throw();

	HRESULT __stdcall Load(LPSTREAM pStm) throw();

	HRESULT __stdcall Save(LPSTREAM pStm, BOOL fClearDirty) throw();

	HRESULT __stdcall GetSizeMax(ULARGE_INTEGER* pcbSize) throw();

	/// IPersistStreamInit

	HRESULT __stdcall InitNew() throw();

private:

	/**
	 * t@Cێ}bv
	 */
	FileInfoMap fileInfoMap_;

	/**
	 * }bvύX邽тɃJEgAbvo[W
	 */
	ULONG version_;

	/**
	 * Ōɕۑꂽo[W
	 */
	ULONG lastSavedVersion_;

};

class __declspec(uuid("F1AFE36B-C50E-4282-99E1-2F5B0645EF78")) CFileInfoEnumerator
	: public IFileInfoEnumerator
	, public CComObjectRoot
	, public CComCoClass<CFileInfoEnumerator>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CFileInfoEnumerator")
	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	BEGIN_COM_MAP(CFileInfoEnumerator)
		COM_INTERFACE_ENTRY(IFileInfoEnumerator)
	END_COM_MAP()

	/// PRIVATE

	HRESULT FinalConstruct() throw();

	HRESULT Init(CFileInfoCollection* v_pParent) throw();

	/// IFileInfoEnumerator

	HRESULT __stdcall Reset() throw();

	HRESULT __stdcall HasNext() throw();

	HRESULT __stdcall Next(BSTR* v_pName, IFileInfo** v_ppFindData) throw();

private:

	/**
	 * eRNṼo[WɕύXȂƂmFB
	 */
	HRESULT CheckVersion() const throw();

	/**
	 * Ce[^̃tO
	 */
	POSITION pos_;

	/**
	 * Ce[^\z̐eRNṼo[W
	 */
	ULONG version_;

	/**
	 * eRNV
	 */
	CFileInfoCollection* pParent_;
};
