#include "stdafx.hpp"

#include <assert.h>

#include "..\FWatch\Task.hpp"

namespace
{
	class TestTask : public Task
	{
	public:

		TestTask( const tstring& v_name, bool v_enableHandle )
			: name_( v_name )
			, hEvent_( NULL )
			, nInitialized_ ( 0 )
			, nExited_( 0 )
		{
			if( v_enableHandle ) {
				hEvent_ = ::CreateEvent( NULL, FALSE, FALSE, NULL );
			}
		}

		virtual ~TestTask()
		{
			if( hEvent_ != NULL ) {
				::CloseHandle( hEvent_ );
			}
			assert( ( nInitialized_ == 0 || nExited_ != 0 ) && "jR[obN܂B" );
		}

		virtual void onThreadBinded()
		{
			//_tprintf( _TEXT("thread#onThreadInit %s\n"), name_.c_str() );
			nInitialized_++;
		}

		virtual void onThreadUnbinded()
		{
			assert( nInitialized_ != 0 && "R[obN܂B" );
			//_tprintf( _TEXT("thread#onThreadExit %s\n"), name_.c_str() );
			nExited_++;
		}

		virtual void onThreadSignal()
		{
			assert( nInitialized_ != 0 && "R[obN܂B" );
			//_tprintf( _TEXT("thread#onThreadSignal %s\n"), name_.c_str() );
		}

		virtual void onThreadTick()
		{
			assert( nInitialized_ != 0 && "R[obN܂B" );
			//_tprintf( _TEXT("thread#onThreadTick %s\n"), name_.c_str() );
		}

		void pulseEvent()
		{
			if( hEvent_ != NULL ) {
				::PulseEvent( hEvent_ );
			}
		}

		HANDLE getWaitableHandle()
		{
			return hEvent_;
		}

		int nInitialized_;
		int nExited_;
		HANDLE hEvent_;
		const tstring name_;
	};
}

void testMultiTask()
{
	const DWORD waitTimeBase = 60;
	ThreadGroupProfile profile;
	profile.setBaseCycleSpan( waitTimeBase / 2 );
	BasicMultiTask taskGroup( profile );
	
	typedef std::vector<Task*> TaskList;
	TaskList taskList;
	
	const int maxtask = 60;
	for( int idx=0; idx<maxtask; idx++ ) {
		TCHAR buf[256];
		_stprintf( buf, _TEXT("No.%d"), idx );
		Task* pTask = new TestTask( buf, true );
		taskList.push_back( pTask );
		const bool result = taskGroup.appendTask( pTask, false );
		assert( result && "o^ɎsĂ܂B" );
	}
	assert( taskGroup.size() == maxtask && "^XNo^v܂B" );

	taskGroup.startSchedule();

	Sleep( waitTimeBase * 3 );

	taskGroup.stopSchedule();
	taskGroup.startSchedule();

	Sleep( waitTimeBase * 3 );

	const DWORD st = ::GetTickCount();
	int count = 0;
	int addcount = 0;
	while( ! taskList.empty() ) {
		TaskList::iterator ite = taskList.begin();
		TestTask* pTask = dynamic_cast<TestTask*>( *ite );
		assert( pTask->nInitialized_ != 0 && "܂Ă܂B" );
		assert( pTask->nInitialized_ == 2 && "JnCxgsł" );
		assert( pTask->nExited_ == 1 && "ICxgsł" );
		
		const bool result = taskGroup.removeTask( pTask );
		assert( result && "폜ɎsĂ܂B" );

		assert( pTask->nExited_ == 2 && "ICxgsł" );
		delete pTask;
		ite =taskList.erase( ite );

		while( ite != taskList.end() ) {
			TestTask* pTestTask = dynamic_cast<TestTask*>( *ite );
			pTestTask->pulseEvent();
			++ite;
		}

		if( ( count % 3 ) == 0 ) {
			TCHAR buf[256];
			_stprintf( buf, _TEXT("AddTask No.%d"), addcount++ );
			Task* pTask = new TestTask( buf, ( count % 5 ) == 0 );
			taskGroup.appendTask( pTask, true ); // taskListɒǉĂȂƂɒӁB
		}
		count++;
		::Sleep( waitTimeBase );
	}
	const DWORD en = ::GetTickCount();
	const DWORD span = (en - st);
	assert( span < (DWORD)( count * waitTimeBase + 1000 ) && "Ԃ肷łB" );
	assert( taskGroup.size() == addcount && "^XNco^v܂B" );

	taskGroup.resetSchedule();
}

void testMultiTaskEx()
{
	const DWORD waitTimeBase = 60;
	ThreadGroupProfile profile;
	profile.setBaseCycleSpan( waitTimeBase / 2 );
	BasicMultiTaskEx taskGroup( profile );

	typedef std::vector<Task*> TaskList;
	TaskList taskList;

	const int mx = 300;
	for( int idx=0; idx<mx; idx++ ) {
		TestTask* pTask = new TestTask( _TEXT("testtask"), false );
		taskList.push_back( pTask );
		const bool result = taskGroup.appendTask( pTask, false );
		assert( result && "o^ɎsĂ܂B" );
	}
	assert( taskGroup.size() == mx && "^XN̐v܂B" );

	taskGroup.startSchedule();
	::Sleep( waitTimeBase * 3 );
	taskGroup.resetSchedule();
	assert( taskGroup.size() == 0 && "^XN̐słB" );

	for( TaskList::iterator ite_taskList = taskList.begin();
		ite_taskList != taskList.end();
		++ite_taskList )
	{
		TestTask* pTask = dynamic_cast<TestTask*>( *ite_taskList );
		assert( pTask->nInitialized_ == 1 && "JnĂ܂B" );
		assert( pTask->nExited_ == 1 && "IĂ܂B" );
		delete pTask;
	}
	taskList.clear();
}

