#include "stdafx.hpp"

#include "..\FWatch\Utility.hpp"

#include <assert.h>

void testIsMatch()
{
	// eXgp^[

	assert( IsMatch( _TEXT(""), _TEXT("") ) );
	assert( ! IsMatch( _TEXT(""), _TEXT("?") ) );
	assert( IsMatch( _TEXT(""), _TEXT("*") ) );

	assert( IsMatch( _TEXT("A"), _TEXT("A") ) );
	assert( IsMatch( _TEXT("A"), _TEXT("?") ) );
	assert( IsMatch( _TEXT("AB"), _TEXT("?B") ) );
	assert( IsMatch( _TEXT("AB"), _TEXT("A?") ) );
	assert( ! IsMatch( _TEXT("AB"), _TEXT("??B") ) );
	assert( ! IsMatch( _TEXT("AB"), _TEXT("A?C") ) );

	assert( IsMatch( _TEXT("ABC"), _TEXT("ABC") ) );
	assert( IsMatch( _TEXT("ABC"), _TEXT("ABC*") ) );
	assert( IsMatch( _TEXT("ABCD"), _TEXT("ABC*") ) );
	assert( IsMatch( _TEXT("ABCABC"), _TEXT("ABC*") ) );

	assert( IsMatch( _TEXT("ABC ABC"), _TEXT("ABC*") ) );
	assert( IsMatch( _TEXT("ABC DEF"), _TEXT("ABC*DEF") ) );
	assert( IsMatch( _TEXT("ABC DEF DEF"), _TEXT("ABC*DEF") ) );
	assert( IsMatch( _TEXT("ABC"), _TEXT("*ABC") ) );
	assert( IsMatch( _TEXT("DEFABC"), _TEXT("*ABC") ) );
	assert( IsMatch( _TEXT("ABCDEFABC"), _TEXT("*DEF*") ) );
	assert( IsMatch( _TEXT("ABCDABC"), _TEXT("*ABC") ) );

	assert( ! IsMatch( _TEXT("ABCDABCD"), _TEXT("*ABC") ) );

	assert( IsMatch( _TEXT("a.txt"), _TEXT("*.txt") ) );
	assert( IsMatch( _TEXT("a.b.txt"), _TEXT("*.txt") ) );
	assert( IsMatch( _TEXT("a.b.txt"), _TEXT("*.b.*") ) );

	assert( ! IsMatch( _TEXT("a.txt.bin"), _TEXT("*.txt") ) );
	assert( ! IsMatch( _TEXT("a.txtx"), _TEXT("*.txt") ) );
	assert( ! IsMatch( _TEXT("a.c.d"), _TEXT("*.b.*") ) );

	assert( ! IsMatch( _TEXT("\"), _TEXT("?\\*") ) );
	assert( ! IsMatch( _TEXT("\"), _TEXT("*\\*") ) );
	assert( ! IsMatch( _TEXT("\\"), _TEXT("?\\*") ) );
	assert( ! IsMatch( _TEXT("\\"), _TEXT("*\\*") ) );
	assert( IsMatch( _TEXT("\\\\"), _TEXT("?\\*") ) );
	assert( IsMatch( _TEXT("\\\\"), _TEXT("*\\\\") ) );
}
