#ifndef INCLUDE_H_XMLWRITER
#define INCLUDE_H_XMLWRITER

#include "SAXContentHandler.hpp"

#include <memory>

#include "SAXAttributesHolder.hpp"

typedef std::auto_ptr<SAXAttributesHolder> SAXAttributesHolderPtr;

class XMLWriter : public SAXContentHandler
{
public:

	virtual ~XMLWriter() throw() {};

	virtual SAXAttributesHolderPtr createAttributesHolder() = 0;
};

typedef std::auto_ptr<XMLWriter> XMLWriterPtr;

class XMLWriterFactory
{
private:
	XMLWriterFactory( const XMLWriterFactory& ); //<! Ȃ
	void operator=( const XMLWriterFactory& ); //<! Ȃ

public:
	XMLWriterFactory();
	~XMLWriterFactory();

	XMLWriterPtr create( const tstring& v_fileName );

};

#endif
