#include "stdafx.hpp"

#include "FWatchApp.hpp"
#include "resource.h"

#include "SettingInfo.hpp"
#include "tstringUty.hpp"

#include <assert.h>


TaskSettingInfo::TaskSettingInfo()
{
	watchFile_ = pApp->LoadString( IDS_DEFAULTPARAM_FINDNAME );
	persistenceDelaySpan_ = pApp->LoadInteger( IDS_PERSISTENCEDELAYSPAN ) * 1000 * 10000;

	nWaitWrite_ = pApp->LoadInteger( IDS_DEFAULTPARAM_WAIT ) * 100 * 10000;
	nTolerance_ = pApp->LoadInteger( IDS_DEFAULTPARAM_TOLERANCE ) * 10000;

	nMaxDepth_ = pApp->LoadInteger( IDS_DEFAULTPARAM_MAXDEPTH );
	nForceInterval_ = pApp->LoadInteger( IDS_DEFAULTPARAM_FORCEINTERVAL ) * 1000;
	nDirNotificationAPIRetryInterval_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DIRNOTIFICATIONRETRYSPAN ) * 1000 * 10000;
	nDirNotificationAPIExpirySpan_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DIRNOTIFICATIONEXPIRYSPAN ) * 1000 * 10000;
	bUsingNotificationAPI_ = pApp->LoadInteger( IDS_DEFAULTPARAM_USEDIRNOTIFICATION ) != 0 ? true : false;

	nDeletePending_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DELETEPENDING ) * 100 * 10000;

	watchDir_.clear();
	persistentFile_.clear();
	log_.clear();

	delaySignalSpan_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DELAYSIGNALSPAN );
}

TaskSettingInfo::TaskSettingInfo( const TaskSettingInfo& v_other )
	: watchDir_( v_other.watchDir_ )
	, watchFile_( v_other.watchFile_ )
	, persistentFile_( v_other.persistentFile_ )
	, persistenceDelaySpan_( v_other.persistenceDelaySpan_ )
	, log_( v_other.log_ )
	, nWaitWrite_( v_other.nWaitWrite_ )
	, nTolerance_ ( v_other.nTolerance_ )
	, nDeletePending_ ( v_other.nDeletePending_ )
	, nMaxDepth_( v_other.nMaxDepth_ )
	, nForceInterval_( v_other.nForceInterval_ )
	, nDirNotificationAPIRetryInterval_( v_other.nDirNotificationAPIRetryInterval_ )
	, nDirNotificationAPIExpirySpan_( v_other.nDirNotificationAPIExpirySpan_ )
	, bUsingNotificationAPI_( v_other.bUsingNotificationAPI_ )
	, delaySignalSpan_( v_other.delaySignalSpan_ )
{
}

TaskSettingInfo& TaskSettingInfo::operator=( const TaskSettingInfo& v_other )
{
	if( &v_other  == this ) {
		return *this;
	}

	watchDir_ = v_other.watchDir_;
	watchFile_ = v_other.watchFile_;
	persistentFile_ = v_other.persistentFile_;
	persistenceDelaySpan_ = v_other.persistenceDelaySpan_;
	log_ = v_other.log_;

	nWaitWrite_ = v_other.nWaitWrite_;
	nTolerance_ = v_other.nTolerance_;
	nDeletePending_ = v_other.nDeletePending_;

	nMaxDepth_ = v_other.nMaxDepth_;
	nForceInterval_ = v_other.nForceInterval_;
	nDirNotificationAPIRetryInterval_ = v_other.nDirNotificationAPIRetryInterval_;
	nDirNotificationAPIExpirySpan_ = v_other.nDirNotificationAPIExpirySpan_;
	bUsingNotificationAPI_ = v_other.bUsingNotificationAPI_;

	delaySignalSpan_ = v_other.delaySignalSpan_;

	return *this;
}


TaskSettingInfo::~TaskSettingInfo()
{
}

