#include "stdafx.hpp"
#include "resource.h"
#include "FWatchApp.hpp"

#include "ServiceEntry.hpp"

// T[rXpϐ
namespace {
	SERVICE_STATUS          ServiceStatus; 
	SERVICE_STATUS_HANDLE   ServiceStatusHandle; 
	LPCTSTR lpszServiceName = _TEXT("SeraphyFWatch");
	LPCTSTR lpszDisplayName = _TEXT("SeraphyFWatch");

	bool g_bWindowsNT;						// WindowsNTtO
}

// T[rXpvg^Cv
VOID WINAPI ServiceStartProc  (DWORD argc, LPTSTR *argv); 
VOID WINAPI ServiceCtrlHandler(DWORD opcode); 

/////////////////////////////////////////////////////////////////////////////
// T[rX[`

BOOL ServiceInit()
{
	g_bWindowsNT = false;
	OSVERSIONINFO osv = {0};
	osv.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if(GetVersionEx(&osv)){
		if(osv.dwPlatformId == VER_PLATFORM_WIN32_NT){
			g_bWindowsNT = true;
		}
	}
	return g_bWindowsNT;
}

void WINAPI ServiceCtrlHandler(DWORD Opcode)
{
	switch(Opcode) 
	{ 
		case SERVICE_CONTROL_PAUSE:
			//TODO: f pApp->getWatchTaskGroupCollection().clear(); //TODO: Stopɂׂł͂ȂH
			ServiceStatus.dwCurrentState = SERVICE_PAUSED; 
			break; 
 
		case SERVICE_CONTROL_CONTINUE: 
			//TODO: f pApp->getWatchTaskGroupCollection().LoadInfData( pApp->getInfPath() ); //TODO: StartKvł͂ȂH
			ServiceStatus.dwCurrentState = SERVICE_RUNNING; 
			break; 
 
		case SERVICE_CONTROL_STOP: 
			ServiceStatus.dwWin32ExitCode = 0; 
			ServiceStatus.dwCurrentState  = SERVICE_STOPPED;
			ServiceStatus.dwCheckPoint    = 0; 
			ServiceStatus.dwWaitHint      = 0; 
			SetServiceStatus (ServiceStatusHandle, &ServiceStatus);
			return; 
 
		case SERVICE_CONTROL_INTERROGATE: 
			break; 
		default:
			break;
    } 
    SetServiceStatus (ServiceStatusHandle,&ServiceStatus);
    return; 
}

void WINAPI ServiceStartProc(DWORD argc, LPTSTR *argv)
{
	// T[rXJnݒ
	ServiceStatusHandle = RegisterServiceCtrlHandler( lpszServiceName, ServiceCtrlHandler);
    if (ServiceStatusHandle == (SERVICE_STATUS_HANDLE)0) {
        return; 
    }

    ServiceStatus.dwServiceType			= SERVICE_WIN32; 
    ServiceStatus.dwControlsAccepted	= SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_PAUSE_CONTINUE;
	ServiceStatus.dwCurrentState		= SERVICE_RUNNING;//SERVICE_STOPPED_PENDING; 
    ServiceStatus.dwWin32ExitCode		= 0; 
    ServiceStatus.dwServiceSpecificExitCode = 0; 
    ServiceStatus.dwCheckPoint			= 0; 
    ServiceStatus.dwWaitHint			= 0; 
    SetServiceStatus (ServiceStatusHandle, &ServiceStatus);
    return; 
} 

int RegistService()
{
	if(!g_bWindowsNT){
		// Windows9xł͓o^̈ӖȂ
		pApp->showMessageBox( MB_ICONERROR|MB_OK, NULL, IDS_SERVICE_W9X );
		return 0;
	}
	// T[rXT[rXRg[}l[Wɓo^܂
	SC_HANDLE schSCManager;
	if(schSCManager = OpenSCManager(
		NULL,                    // local machine 
		NULL,                    // ServicesActive database 
		SC_MANAGER_ALL_ACCESS)){  // full access rights 
		
		// st@C̎擾
		TCHAR lpszBinaryPathName[ MAX_PATH * 2 ];
		GetModuleFileName(NULL,lpszBinaryPathName,MAX_PATH);
		lstrcat( lpszBinaryPathName, _TEXT(" /runservice") );

		// o^
		SC_HANDLE schService = CreateService( 
			schSCManager,              // SCManager database 
			lpszServiceName,           // name of service 
			lpszDisplayName,           // service name to display 
			SERVICE_ALL_ACCESS,        // desired access 
			SERVICE_WIN32_OWN_PROCESS, // service type 
			SERVICE_DEMAND_START,      // start type 
			SERVICE_ERROR_NORMAL,      // error control type 
			lpszBinaryPathName,        // service's binary 
			NULL,                      // no load ordering group 
			NULL,                      // no tag identifier 
			NULL,                      // no dependencies 
			NULL,                      // LocalSystem account 
			NULL);                     // no password 
		// bZ[W
		if(schService){
			pApp->showMessageBox( MB_ICONINFORMATION | MB_OK, NULL, IDS_MAINPROC_INSTALLSERVICE );
		}
		else{
			DWORD err = GetLastError();
			if(err == ERROR_SERVICE_EXISTS || err == ERROR_DUP_NAME){
				pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_SERVICEEXIST );
			}
			else{
				pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INSTALLFAIL );
			}
		}
		// n
		CloseServiceHandle(schService); 
		CloseServiceHandle(schSCManager);
	}
	return 0;
}

int UnregistService()
{
	if(!g_bWindowsNT){
		// Windows9xł͉̈ӖȂ
		pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_SERVICE_W9X );
		return 0;
	}
	// T[rXT[rXRg[}l[Wɓo^܂
	SC_HANDLE schSCManager;
	if(schSCManager = OpenSCManager(
		NULL,                    // local machine 
		NULL,                    // ServicesActive database 
		SC_MANAGER_ALL_ACCESS)){  // full access rights 
		
		// o^
		SC_HANDLE schService = OpenService( 
			schSCManager,              // SCManager database 
			lpszServiceName,           // name of service 
			SERVICE_ALL_ACCESS);        // desired access 
		if(schService){
			if(DeleteService(schService)){
				pApp->showMessageBox( MB_ICONINFORMATION | MB_OK, NULL, IDS_MAINPROC_UNINSTALLSERVICE );
			}
			else{
				pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_UNINSTALLFAIL );
			}
		}
	}
	return 0;
}

BOOL IsRegistService(BOOL& bStartService)
{
	if( ! g_bWindowsNT ) {
		return FALSE;
	}

	BOOL ret = false;
	bStartService = false;
	SC_HANDLE schSCManager;
	if(schSCManager = OpenSCManager(
		NULL,                    // local machine 
		NULL,                    // ServicesActive database 
		SC_MANAGER_ALL_ACCESS)){  // full access rights 
		
		SC_HANDLE schService = OpenService(schSCManager,lpszServiceName,SERVICE_QUERY_STATUS |GENERIC_READ);
		if(schService){
			SERVICE_STATUS sst = { 0 };
			if(QueryServiceStatus(schService,&sst)){
				if( sst.dwCurrentState == SERVICE_RUNNING ||
					sst.dwCurrentState == SERVICE_PAUSED ){
					// T[rX͌ݓ쒆ł
					bStartService = true;
				}
			}
			CloseServiceHandle(schService); 
			// T[rX̓CXg[Ă
			ret = true;
		}
		CloseServiceHandle(schSCManager);
	}
	return ret;
}

BOOL StartService()
{
	// T[rX̓o^s܂
    SERVICE_TABLE_ENTRY   ServiceDispatchTable[] = { 
        { (LPTSTR) lpszServiceName, ServiceStartProc  }, 
        { NULL, NULL }
	}; 
	return ::StartServiceCtrlDispatcher( ServiceDispatchTable );
}

void ServiceRetart()
{
	//TODO: f 
	//// ċN
	//pApp->getWatchTaskGroup().SaveInfData( pApp->getInfPath() );
	//pApp->getWatchTaskGroup().clear(); //TODO: Stopł͂ȂH
	//pApp->getWatchTaskGroup().LoadInfData( pApp->getInfPath() ); //TODO: Startł͂ȂH
	////
	//// T[rXRg[}l[W̎擾ƁAT[rX̊Jn
	//SC_HANDLE schSCManager;
	//if(schSCManager = OpenSCManager(
	//	NULL,                    // local machine 
	//	NULL,                    // ServicesActive database 
	//	SC_MANAGER_ALL_ACCESS)){  // full access rights 
	//	
	//	SC_HANDLE schService = OpenService(schSCManager,lpszServiceName,SERVICE_START|SERVICE_STOP|GENERIC_EXECUTE);
	//	if(schService){
	//		LPCTSTR param[] = { pApp->getInfPath().c_str() ,NULL };
	//		if( ! ::StartService( schService, 1, param ) ){
	//			DWORD err = GetLastError();
	//			if(err == ERROR_SERVICE_ALREADY_RUNNING){
	//				pApp->showMessageBox( MB_ICONERROR | MB_OK, lpszServiceName, IDS_SERVICE_RUNNING );
	//			}
	//			else if(err == ERROR_SERVICE_DISABLED){
	//				pApp->showMessageBox( MB_ICONERROR | MB_OK, lpszServiceName, IDS_SERVICE_DISABLED );
	//			}
	//			else{
	//				pApp->showMessageBox( MB_ICONERROR | MB_OK, lpszServiceName,IDS_SERVICE_STARTERROR );
	//			}
	//		}
	//		else{
	//			pApp->showMessageBox( MB_ICONINFORMATION | MB_OK, lpszServiceName, IDS_SERVICE_START );
	//		}
	//		CloseServiceHandle(schService); 
	//	}
	//	CloseServiceHandle(schSCManager);
	//}
}

void ServiceStop()
{
	//TODO: f 
	//// T[rXRg[}l[W̎擾ƁAT[rX̒~
	//SC_HANDLE schSCManager;
	//if(schSCManager = OpenSCManager(
	//	NULL,                    // local machine 
	//	NULL,                    // ServicesActive database 
	//	SC_MANAGER_ALL_ACCESS)){  // full access rights 
	//	
	//	SC_HANDLE schService = OpenService(schSCManager,lpszServiceName,SERVICE_START|SERVICE_STOP|GENERIC_EXECUTE);
	//	if(schService){
	//		SERVICE_STATUS sst;
	//		if(!ControlService(schService,SERVICE_CONTROL_STOP,&sst)){
	//			DWORD err = GetLastError();
	//			if(err != ERROR_SERVICE_NOT_ACTIVE){
	//				pApp->showMessageBox( MB_ICONERROR | MB_OK, lpszServiceName, IDS_SERVICE_STOPERROR );
	//			}
	//		}
	//		else{
	//			pApp->showMessageBox( MB_ICONINFORMATION | MB_OK, lpszServiceName, IDS_SERVICE_STOP );
	//		}
	//		CloseServiceHandle(schService); 
	//	}
	//	CloseServiceHandle(schSCManager);
	//}
}
