#ifndef INCLUDE_H_SAXATTRIBUTES
#define INCLUDE_H_SAXATTRIBUTES

#include "tstring.hpp"

class SAXAttributes
{
public:
	virtual ~SAXAttributes() {}

	virtual int getLength() const = 0;
	virtual tstring getURI(int) const = 0;
	virtual tstring getLocalName(int) const = 0;
	virtual tstring getQName(int) const = 0;
	virtual void getName(int, tstring*, tstring*, tstring* ) const = 0;
	virtual int getIndexFromName( const tstring&, const tstring& ) const = 0;
	virtual int getIndexFromQName( const tstring& ) const = 0;
	virtual tstring getType(int) const = 0;
	virtual tstring getTypeFromName( const tstring&, const tstring& ) const = 0;
	virtual tstring getTypeFromQName( const tstring& ) const = 0;
	virtual tstring getValue(int) const = 0;
	virtual tstring getValueFromName( const tstring&, const tstring& ) const = 0;
	virtual tstring getValueFromQName( const tstring& ) const = 0;
};

#endif
