#include "stdafx.hpp"

#include "FWatchConfigXMLPersistent.hpp"

#include "SettingInfoFactory.hpp"

namespace
{
	class SettingInfoFactoryAdaptor
	{
	private:
		CSettingInfoFactory& factory_;
	public:
		SettingInfoFactoryAdaptor( CSettingInfoFactory& v_factory )
			: factory_( v_factory )
		{
		}

		void setWatchDir( const tstring& arg ) {
			factory_.setWatchDir( arg );
		}

		void setWatchFile( const tstring& arg ) {
			factory_.setWatchFile( arg );
		}

		void setWaitWrite( const tstring& arg ) {
			factory_.setWaitWrite( tstringuty::atoi( arg ) );
		}

		void setTolerance( const tstring& arg ) {
			factory_.setTolerance( tstringuty::atoi( arg ) );
		}

		void setMaxDepth( const tstring& arg ) {
			factory_.setMaxDepth( tstringuty::atoi( arg ) );
		}

		void setUsingDirNotificationAPI( const tstring& arg ) {
			factory_.setUsingDirNotificationAPI( tstringuty::atoi( arg ) != 0 );
		}

		void setForceInterval( const tstring& arg ) {
			factory_.setForceInterval( tstringuty::atoi( arg ) );
		}

		void setDeletePending( const tstring& arg ) {
			factory_.setDeletePending( tstringuty::atoi( arg ) );
		}

		void setDirNotificationAPIExpirySpan( const tstring& arg ) {
			factory_.setDirNotificationAPIExpirySpan( tstringuty::atoi( arg ) );
		}

		void setDirNotificationAPIRetryInterval( const tstring& arg ) {
			factory_.setDirNotificationAPIRetryInterval( tstringuty::atoi( arg ) );
		}

		void setDelaySignalSpan( const tstring& arg ) {
			factory_.setDelaySignalSpan( tstringuty::atoi( arg ) );
		}

		void setPersistentFile( const tstring& arg ) {
			factory_.setPersistentFile( arg );
		}

		void setPersistenceDelaySpan( const tstring& arg ) {
			factory_.setPersistenceDelaySpan( tstringuty::atoi( arg ) );
		}

		typedef void (SettingInfoFactoryAdaptor::*adaptorFunc)( const tstring& );

		static const SettingInfoFactoryAdaptor::adaptorFunc inputListFunctions[]; 
	};


	const SettingInfoFactoryAdaptor::adaptorFunc SettingInfoFactoryAdaptor::inputListFunctions[] = {
		SettingInfoFactoryAdaptor::setWatchDir,
		SettingInfoFactoryAdaptor::setWatchFile,
		SettingInfoFactoryAdaptor::setWaitWrite,
		SettingInfoFactoryAdaptor::setTolerance,
		SettingInfoFactoryAdaptor::setDeletePending,
		SettingInfoFactoryAdaptor::setMaxDepth,
		SettingInfoFactoryAdaptor::setUsingDirNotificationAPI,
		SettingInfoFactoryAdaptor::setForceInterval,
		SettingInfoFactoryAdaptor::setDirNotificationAPIExpirySpan,
		SettingInfoFactoryAdaptor::setDirNotificationAPIRetryInterval,
		SettingInfoFactoryAdaptor::setDelaySignalSpan,
		SettingInfoFactoryAdaptor::setPersistentFile,
		SettingInfoFactoryAdaptor::setPersistenceDelaySpan,
		NULL
	};
}

void FWatchConfigXMLPersistent::load( WatchTaskGroupCollection& v_watchTaskGroupCollection, const tstring& v_fileName )
{
	v_watchTaskGroupCollection.clear();
}

void FWatchConfigXMLPersistent::save( const WatchTaskGroupCollection& v_watchTaskGroupCollection, const tstring& v_fileName )
{
}
	//required:
	//assert( ! multiTask_.isScheduling() && "XbhsłB" );

	//do:
	//clear();
	//if( InfPath.empty() ) {
	//	return false;
	//}

	//bool succeeded = false;
	//try{
	//	std::ifstream fin;
	//	std::string infPath( tstringuty::getStdString( InfPath ) );
	//	fin.open( infPath.c_str() );
	//	if( ! fin.is_open() ) {
	//		return false;
	//	}

	//	const TaskSettingInfo defaultParameter;

	//	std::string line;
	//	while( std::getline( fin, line ) ) {
	//		::OutputDebugString( tstringuty::getTString( line ).c_str() );

	//		CSettingInfoFactory factory( defaultParameter );
	//		SettingInfoFactoryAdaptor adaptor( factory );

	//		int col = 0;
	//		std::string::size_type lastpos = 0;
	//		for(;;) {
	//			const std::string::size_type pos = line.find( '\t', lastpos );
	//			std::string arg;
	//			if( pos != tstring::npos ) {
	//				arg = line.substr( lastpos, pos - lastpos );
	//			}
	//			else {
	//				arg = line.substr( lastpos );
	//			}
	//			
	//			SettingInfoFactoryAdaptor::adaptorFunc func = SettingInfoFactoryAdaptor::inputListFunctions[ col ];
	//			if( func == NULL ) {
	//				break;
	//			}

	//			(adaptor.*func)( tstringuty::getTString( arg ) );

	//			col++;
	//			lastpos = pos + 1;
	//			if( pos == tstring::npos ) {
	//				break;
	//			}
	//		}

	//		push_back( factory.create() );
	//	}
	//	fin.close();
	//	succeeded = true;
	//}
	//catch( const std::exception& v_exception ) {
	//	pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFLOADFAILED, tstringuty::getTString( v_exception.what() ).c_str() );
	//}

	//modified_ = false;
	//return succeeded;




	//if( InfPath.empty() ) {
	//	return false; //TODO: OɂB
	//}

	//WatchTaskGroup* pWatchTaskGroup = watchTaskGroups_[ 0 ].first;

	//bool succeeded = false;
	//try{
	//	std::ofstream fout;
	//	fout.exceptions( std::ios::failbit | std::ios::badbit );

	//	std::string infPath( tstringuty::getStdString( InfPath ) );
	//	fout.open( infPath.c_str() );
	//	if( ! fout.is_open() ) {
	//		return false;
	//	}
	//	for( WatchTaskList::const_iterator ite = taskList_.begin();
	//		ite != taskList_.end();
	//		++ite )
	//	{
	//		const WatchTask* pWatchThread = *ite;
	//		const TaskSettingInfo& settingInfo = pWatchThread->getSettingInfo();

	//		fout << tstringuty::getStdString( settingInfo.getWatchDir()	)		<< "\t";
	//		fout << tstringuty::getStdString( settingInfo.getWatchFile() )		<< "\t";
	//		fout << tstringuty::getStdString( settingInfo.getActionSettingInfo().getAction() )	<< "\t";
	//		fout << tstringuty::getStdString( settingInfo.getActionSettingInfo().getAppName() )	<< "\t";
	//		fout << tstringuty::getStdString( settingInfo.getActionSettingInfo().getParam() )	<< "\t";
	//		fout << settingInfo.getActionSettingInfo().getMaxProcess()			<< "\t";
	//		fout << settingInfo.getActionSettingInfo().getShowWindow()			<< "\t";
	//		fout << settingInfo.getWaitWrite().GetTimeSpan()					<< "\t";
	//		fout << settingInfo.getTolerance().GetTimeSpan()					<< "\t";
	//		fout << settingInfo.getDeletePending().GetTimeSpan()				<< "\t";
	//		fout << tstringuty::getStdString( settingInfo.getLog() )			<< "\t";
	//		fout << settingInfo.getMaxDepth()									<< "\t";
	//		fout << ( settingInfo.isUsingDirNotificationAPI() ? 1 : 0 )			<< "\t";
	//		fout << settingInfo.getForceInterval().GetTimeSpan()				<< "\t";
	//		fout << settingInfo.getDirNotificationAPIExpirySpan().GetTimeSpan()	<< "\t";
	//		fout << settingInfo.getDirNotificationAPIRetryInterval().GetTimeSpan()	<< "\t";
	//		fout << settingInfo.getDelaySignalSpan().GetTimeSpan()				<< "\t";
	//		fout << tstringuty::getStdString( settingInfo.getActionSettingInfo().getAppCurrentDir() )	<< "\t";
	//		fout << tstringuty::getStdString( settingInfo.getPersistentFile() )	<< "\t";
	//		fout << settingInfo.getPersistenceDelaySpan().GetTimeSpan()			<< std::endl;
	//	}

	//	modified_ = false;
	//	succeeded = true;
	//}
	//catch( const std::exception& v_exception ) {
	//	pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_INFSAVEFAILED, tstringuty::getTString( v_exception.what() ).c_str() );
	//}

	//return succeeded;
