#include "stdafx.hpp"

#include "ExecuteActionSettingInfo.hpp"

#include "tstringUty.hpp"

#include <assert.h>

ExecuteActionSettingInfo::ExecuteActionSettingInfo( const ActionSettingParameter& v_parameter )
	: parameter_( v_parameter )
{
	action_        = v_parameter.getParameter( _TEXT("ACTION"      ) );
	appName_       = v_parameter.getParameter( _TEXT("APPLICATION" ) );
	param_         = v_parameter.getParameter( _TEXT("PARAMETER"   ) );
	appCurrentDir_ = v_parameter.getParameter( _TEXT("CURRENT_DIR" ) );
	showWindow_    = ShowWindowType::valueOf( tstringuty::atoi( v_parameter.getParameter( _TEXT("SHOW_WINDOW") ) ) );
	nMaxProcess_   = tstringuty::atoi( v_parameter.getParameter( _TEXT("MAX_PROCESS") ) );
}

ExecuteActionSettingInfo::ExecuteActionSettingInfo( const ExecuteActionSettingInfo& v_other )
	: parameter_( v_other.parameter_ )
	, action_( v_other.action_ )
	, appName_( v_other.appName_ )
	, param_( v_other.param_ )
	, showWindow_( v_other.showWindow_ )
	, nMaxProcess_( v_other.nMaxProcess_ )
	, appCurrentDir_( v_other.appCurrentDir_ )
{
}

ExecuteActionSettingInfo& ExecuteActionSettingInfo::operator=( const ExecuteActionSettingInfo& v_other )
{
	if( this != &v_other ) {
		parameter_ = v_other.parameter_;
		action_ = v_other.action_;
		appName_ = v_other.appName_;
		param_ = v_other.param_;
		showWindow_ = v_other.showWindow_;
		nMaxProcess_ = v_other.nMaxProcess_;
		appCurrentDir_ = v_other.appCurrentDir_;
	}
	return *this;
}

ExecuteActionSettingInfo::~ExecuteActionSettingInfo()
{
}
