#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "EventListenerFactoryChoiceDialog.hpp"

#include <assert.h>

EventListenerFactoryChoiceDialog::EventListenerFactoryChoiceDialog()
	: hDlg_( NULL )
	, hEventListenerList_( NULL )
	, selectedFactory_( NULL )
{
}

EventListenerFactoryChoiceDialog::~EventListenerFactoryChoiceDialog()
{
}

const ActionInvokerFactory* EventListenerFactoryChoiceDialog::selectFactory( HWND v_hParent )
{
	selectedFactory_ = NULL;
	::DialogBoxParam(
		pApp->getInstanceHandle(),
		MAKEINTRESOURCE( IDD_CHOICEEVENTLISTENER ),
		v_hParent,
		DlgProc,
		(LPARAM) this
		);
	return selectedFactory_;
}

void EventListenerFactoryChoiceDialog::onInitDialog()
{
	hEventListenerList_ = GetDlgItem( hDlg_, IDC_EVENTLISTENERLIST );
	assert( hEventListenerList_ != NULL );

	const ActionInvokerFactoryManager& factoryManager( pApp->getActionInvokerFactoryManager() );
	for( ActionInvokerFactoryManager::const_iterator ite = factoryManager.begin();
		ite != factoryManager.end();
		++ite )
	{
		const ActionInvokerFactory& factory = *ite;
		const LRESULT idx = ::SendMessage( hEventListenerList_, LB_ADDSTRING, NULL, reinterpret_cast<LPARAM>( factory.getDescription() ) );
		if( idx != LB_ERR && idx != LB_ERRSPACE ) {
			const LRESULT ret = ::SendMessage( hEventListenerList_, LB_SETITEMDATA, idx, reinterpret_cast<LPARAM>( &factory ) );
			assert( ret != LB_ERR );
		}
	}
}

BOOL EventListenerFactoryChoiceDialog::onCommand( UINT v_id )
{
	switch( v_id )
	{
	case IDOK:
		onOK();
		return TRUE;

	case IDCANCEL:
		onCancel();
		return TRUE;

	default:
		break;
	}

	return FALSE;
}

void EventListenerFactoryChoiceDialog::onOK()
{
	const LRESULT idx = ::SendMessage( hEventListenerList_, LB_GETCURSEL, 0, 0 );
	if( idx != LB_ERR ) {
		const ActionInvokerFactory* factory = reinterpret_cast<const ActionInvokerFactory*>(
			::SendMessage( hEventListenerList_, LB_GETITEMDATA , idx, 0 )
			);
		assert( factory != NULL );
		selectedFactory_ = factory;
		EndDialog( hDlg_, IDOK );
	}
}

void EventListenerFactoryChoiceDialog::onCancel()
{
	EndDialog( hDlg_, IDCANCEL );
}

INT_PTR CALLBACK EventListenerFactoryChoiceDialog::DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
#pragma warning( push )
#pragma warning( disable : 4312 4244 )

	EventListenerFactoryChoiceDialog* me = reinterpret_cast<EventListenerFactoryChoiceDialog*>( ::GetWindowLongPtr( hDlg, DWLP_USER ) );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( message == WM_INITDIALOG ) {
		me = (EventListenerFactoryChoiceDialog*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, reinterpret_cast<LONG_PTR>( me ) );
		me->hDlg_ = hDlg;
		me->onInitDialog();
	}
	else {
		if( message == WM_COMMAND ) {
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			return me->onCommand( LOWORD(wParam) );
		}
	}
    return FALSE;

#pragma warning( pop )
}

