#ifndef INCLUDE_H_EVENTLISTENER
#define INCLUDE_H_EVENTLISTENER

#include "tstring.hpp"
#include "FileInfo.hpp"

#include "tstring.hpp"

class EventListener
{
public:
	enum EventType
	{
		DETECT_MODIFIED = 0,
		DETECT_REMOVED  = 1,
		REMOVE_PENDING  = 2,
		UPDATE_ENTRY    = 3,
		NEW_ENTRY       = 4,
	};

	enum StateEventType
	{
		BIND_THREAD      = 0,
		UNBIND_THREAD    = 1,
		THREAD_SIGNAL    = 2,
		FORCE_INTERVAL   = 3,
		ENUM_FILES       = 4,
		WATCHAPI_CREATED = 5,
		WATCHAPI_CREATE_FAILURE = 6
	};

	virtual ~EventListener() throw() {}

	virtual void tickEventCycle() throw() = 0;

	virtual void notifyFileEvent( EventType v_eventId, const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw() = 0;
	virtual void notifyStateEvent( StateEventType v_eventId ) throw() = 0;

	virtual tstring getDescription() const throw() = 0;
};

#endif
