#ifndef INCLUDE_H_DIALOGLAYOUTEXPANDER
#define INCLUDE_H_DIALOGLAYOUTEXPANDER

#include <list>

class DialogLayoutExpander
{
public:
	DialogLayoutExpander();
	~DialogLayoutExpander();

	void setParent( HWND v_hWnd );
	void addChild( HWND v_hWnd, DWORD v_flag );

	void layout( LPRECT v_pRect );

	enum LAYOUT_FLAG
	{
		NONE = 0,
		MOVE_LEFT = 1,
		MOVE_TOP = 2,
		MOVE_RIGHT = 4,
		MOVE_BOTTOM = 8
	};
private:
	struct WindowInfo
	{
		HWND hWnd;
		RECT rect;
		DWORD flag;
	};

	WindowInfo parent_;

	typedef std::list<WindowInfo> ChildList;
	ChildList children_;
};

#endif
