#ifndef INCLUDE_H_ACTIONSETTINGPARAMETER
#define INCLUDE_H_ACTIONSETTINGPARAMETER

#include <map>

#include "tstring.hpp"

class ActionSettingParameter
{
public:
	ActionSettingParameter();
	ActionSettingParameter( const ActionSettingParameter& v_other );
	ActionSettingParameter& operator=( const ActionSettingParameter& v_other );
	virtual ~ActionSettingParameter();
	
	virtual tstring getActionType() const;
	virtual void setActionType( const tstring& v_name );

	virtual tstring getParameter( const tstring& v_name ) const;
	virtual void setParameter( const tstring& v_name, const tstring& v_value );
	virtual size_t size() const;

	virtual void savePersistence() const;
	virtual void loadPersistence();

private:
	typedef std::map<tstring, tstring> tstring_map;
	tstring actionTypeName_;
	tstring_map parameters_;
};

#endif
