#ifndef INCLUDE_H_ACTIONINVOKERFACTORYMANAGER
#define INCLUDE_H_ACTIONINVOKERFACTORYMANAGER

#include "ActionInvokerFactory.hpp"

#include <map>

/*!
 * ANVNIuWFNg̃t@NgǗB
 */
class ActionInvokerFactoryManager
{
private:
	ActionInvokerFactoryManager( const ActionInvokerFactoryManager& ); //<! Ȃ
	void operator=( const ActionInvokerFactoryManager& ); //<! Ȃ

private:
	typedef std::map<tstring, ActionInvokerFactory*> ActionInvokerFactoryMap;

public:
	class ActionInvokerFactoryManagerIterator
	{
	public:
		ActionInvokerFactoryManagerIterator( ActionInvokerFactoryMap::const_iterator v_iterator )
			: ite_( v_iterator )
		{
		}

		ActionInvokerFactoryManagerIterator( const ActionInvokerFactoryManagerIterator& v_other )
			: ite_( v_other.ite_ )
		{
		}

		ActionInvokerFactoryManagerIterator& operator=( const ActionInvokerFactoryManagerIterator& v_other )
		{
			if( this != &v_other ) {
				ite_ = v_other.ite_;
			}
			return *this;
		}

		~ActionInvokerFactoryManagerIterator()
		{
		}

		ActionInvokerFactoryManagerIterator& operator++()
		{
			++ite_;
			return *this;
		}

		bool operator==( const ActionInvokerFactoryManagerIterator& v_other ) const
		{
			return ite_ == v_other.ite_;
		}

		bool operator!=( const ActionInvokerFactoryManagerIterator& v_other ) const
		{
			return ite_ != v_other.ite_;
		}

		const ActionInvokerFactory& operator*() const
		{
			const ActionInvokerFactory* pFactory = ite_->second;
			return *pFactory;
		}

		const ActionInvokerFactory& operator->() const
		{
			const ActionInvokerFactory* pFactory = ite_->second;
			return *pFactory;
		}

	private:
		ActionInvokerFactoryMap::const_iterator ite_;
	};

	typedef ActionInvokerFactoryManagerIterator const_iterator;
	typedef const ActionInvokerFactory& const_reference;
	typedef size_t size_type;

public:

	/*!
	 * ftHgRXgN^
	 */
	ActionInvokerFactoryManager();

	/*!
	 * fXgN^B
	 * ێĂAׂẴt@Ng̎QƃJEg܂B
	 */
	~ActionInvokerFactoryManager();

	/*!
	 * w肵ANV^Cṽt@Ng擾܂B
	 * YꍇNULLԂ܂B
	 * \param v_actionType ANV^Cv
	 * \return t@Ng[̃|C^A܂NULL
	 */
	ActionInvokerFactory* getFactory( const tstring& v_actionType ) const;

	/*!
	 * t@Ng̍ŏ̗vfCe[^Ԃ܂B
	 * \return Ce[^
	 */
	const_iterator begin() const
	{
		return ActionInvokerFactoryManagerIterator( actionInvokerFactories_.begin() );
	}

	/*!
	 * t@Ng̏I[+1Ce[^Ԃ܂B
	 * \return Ce[^
	 */
	const_iterator end() const
	{
		return ActionInvokerFactoryManagerIterator( actionInvokerFactories_.end() );
	}

	/*!
	 * t@NǧԂ܂B
	 * \return t@Nǧ
	 */
	size_type size() const
	{
		return actionInvokerFactories_.size();
	}

	/*!
	 * t@Ngǉ܂B
	 * t@Ng̎QƃJEg܂B
	 */
	void appendFactory( ActionInvokerFactory* const v_factory, const bool v_addRef = true );

	/*!
	 * YANV^Cṽt@NgꍇÃt@Ng폜܂B
	 * QƃJEg͌܂B
	 * YANV^Cvo^ĂȂꍇ͉܂B
	 */
	void remove( const tstring& v_actionType );

private:
	ActionInvokerFactoryMap actionInvokerFactories_;
};

#endif
