#include "stdafx.hpp"

#include "WatchTaskGroupCollection.hpp"
#include "FWatchConfigPersistent.hpp"

WatchTaskGroupCollection::WatchTaskGroupCollection( bool v_dryRun )
	: dryRun_( v_dryRun )
	, runnung_( false )
	, modified_( false )
	, EventDispatcher( _TEXT("WatchTaskGroupCollection EventDispatcher") )
{
}

WatchTaskGroupCollection::~WatchTaskGroupCollection() throw()
{
	clear();
}

WatchTaskGroupCollection::iterator WatchTaskGroupCollection::begin()
{
	return watchTaskGroups_.begin();
}

WatchTaskGroupCollection::const_iterator WatchTaskGroupCollection::begin() const
{
	return watchTaskGroups_.begin();
}

WatchTaskGroupCollection::iterator WatchTaskGroupCollection::end()
{
	return watchTaskGroups_.end();
}

WatchTaskGroupCollection::const_iterator WatchTaskGroupCollection::end() const
{
	return watchTaskGroups_.end();
}

void WatchTaskGroupCollection::clear() throw()
{
	for( WatchTaskGroupList::iterator ite = watchTaskGroups_.begin(), last = watchTaskGroups_.end();
		ite != last;
		++ite )
	{
		WatchTaskGroup* pWatchTaskGroup = *ite;
		pWatchTaskGroup->clear();
		delete pWatchTaskGroup;
	}
	watchTaskGroups_.clear();
	runnung_ = false;
	modified_ = false;
}

bool WatchTaskGroupCollection::empty() const throw()
{
	return watchTaskGroups_.empty();
}

WatchTaskGroup* WatchTaskGroupCollection::createWatchTaskGroup( const ThreadGroupProfile& v_threadGroupProfile )
{
	WatchTaskGroup* pWatchTaskGroup = new WatchTaskGroup( dryRun_, v_threadGroupProfile );
	pWatchTaskGroup->appendEventListener( this );

	watchTaskGroups_.push_back( pWatchTaskGroup );
	modified_ = true;
	if( runnung_ ) {
		pWatchTaskGroup->startWatch();
	}
	return pWatchTaskGroup;
}

size_t WatchTaskGroupCollection::find( const WatchTaskGroup* v_watchTaskGroup ) const throw()
{
	assert( v_watchTaskGroup != NULL );

	size_t idx = 0;
	for( WatchTaskGroupList::const_iterator ite = watchTaskGroups_.begin(), last = watchTaskGroups_.end();
		ite != last;
		++ite, ++idx )
	{
		if( v_watchTaskGroup == *ite ) {
			return idx;
		}
	}
	return -1;
}

void WatchTaskGroupCollection::erase( size_t idx ) throw()
{
	WatchTaskGroupList::iterator ite = watchTaskGroups_.begin() + idx ;
	WatchTaskGroup* pWatchTaskGroup = *ite;
	pWatchTaskGroup->clear();
	delete pWatchTaskGroup;
	watchTaskGroups_.erase( ite );
	modified_ = true;
}

WatchTaskGroup*& WatchTaskGroupCollection::operator[]( size_t idx ) throw()
{
	return watchTaskGroups_[ idx ];
}

WatchTaskGroup* const & WatchTaskGroupCollection::operator[]( size_t idx ) const throw()
{
	return watchTaskGroups_[ idx ];
}

size_t WatchTaskGroupCollection::size() const throw()
{
	return watchTaskGroups_.size();
}

bool WatchTaskGroupCollection::isModified() const throw()
{
	if( modified_ ) {
		return true;
	}

	for( WatchTaskGroupList::const_iterator ite = watchTaskGroups_.begin(), last = watchTaskGroups_.end();
		ite != last;
		++ite )
	{
		WatchTaskGroup* pWatchTaskGroup = *ite;
		if( pWatchTaskGroup->isModified() ) {
			return true;
		}
	}
	return false;
}


bool WatchTaskGroupCollection::isDryRun() const throw()
{
	return dryRun_;
}

void WatchTaskGroupCollection::startWatch()
{
	runnung_ = true;
	for( WatchTaskGroupList::const_iterator ite = watchTaskGroups_.begin(), last = watchTaskGroups_.end();
		ite != last;
		++ite )
	{
		WatchTaskGroup* pWatchTaskGroup = *ite;
		pWatchTaskGroup->startWatch();
	}
}

void WatchTaskGroupCollection::stopWatch()
{
	runnung_ = false;
	for( WatchTaskGroupList::const_iterator ite = watchTaskGroups_.begin(), last = watchTaskGroups_.end();
		ite != last;
		++ite )
	{
		WatchTaskGroup* pWatchTaskGroup = *ite;
		pWatchTaskGroup->stopWatch();
	}
}

void WatchTaskGroupCollection::load( const tstring& v_fileName )
{
	FWatchConfigXMLPersistent xmlPersistent;
	xmlPersistent.load( *this, v_fileName );
	modified_ = false;
}

void WatchTaskGroupCollection::save( const tstring& v_fileName ) const
{
	FWatchConfigXMLPersistent xmlPersistent;
	xmlPersistent.save( *this, v_fileName );
	modified_ = false;
}
