#ifndef INCLUDE_H_WATCHTASKGROUP
#define INCLUDE_H_WATCHTASKGROUP

#include "WatchTask.hpp"
#include "SettingInfo.hpp"

#include "Thread.hpp"
#include "EventDispatcher.hpp"

#include "tstring.hpp"

#include <iterator>
#include <vector>

class WatchTaskGroup : public virtual EventDispatcher
{
private:
	WatchTaskGroup( const WatchTaskGroup& ); //<! Ȃ
	operator=( const WatchTaskGroup& ); //<! Ȃ

public:

	typedef WatchTask** iterator;
	typedef WatchTask* const * const_iterator;

	WatchTaskGroup::iterator begin();
	WatchTaskGroup::const_iterator begin() const;
	WatchTaskGroup::iterator end();
	WatchTaskGroup::const_iterator end() const;
	
	/*!
	 * ĎXbhO[v\z܂B
	 * hC[hLɂƃXbh͎ۂɂ͍쐬ꂸҏŴ݂ƂȂ܂B
	 * \param v_dryrun hC[h̏ꍇAtrue
	 * \param v_threadGroupProfile XbhO[vvt@C
	 */
	WatchTaskGroup( const bool v_dryrun, const ThreadGroupProfile& v_threadGroupProfile );

	virtual ~WatchTaskGroup();
	
	/*!
	 * ĎXbhJn܂B
	 * hC̏ꍇ͉܂B
	 */
	void startWatch();

	/*!
	 * ĎXbh~܂B
	 * hC̏ꍇ͉܂B
	 */
	void stopWatch();

	/*!
	 * ĎXbh~AׂẴ^XNNA܂B
	 */
	void clear();

	/*!
	 * ĎXbhsłtrueԂ܂B
	 * \return ĎXbhsłtrue
	 */
	bool isRunning() const;

	/*!
	 * hC[hł邩擾܂B
	 * \return hC[hłtrue
	 */
	bool isDryRun() const;

	/*!
	 * ^XNǉ܂B
	 * XbhɃoCh܂B
	 * \param v_settingInfo ^XN
	 * \return V쐬ꂽ^XN
	 */
	WatchTask* createWatchTask( const TaskSettingInfo& v_settingInfo );

	/*!
	 * w肵CfbNX̃^XNu܂B
	 * ݂̃^XN͍폜XbhAoChꂽ̂A
	 * V^XNǉAXbhɃoCh܂B
	 * \param idx CfbNX
	 * \param v_settingInfo ^XN
	 * \return V쐬ꂽ^XN
	 */
	WatchTask* replace( size_t idx, const TaskSettingInfo& v_settingInfo );

	/*!
	 * ^XÑCfbNX擾܂B
	 * ݂Ȃꍇ-1Ԃ܂B
	 */
	size_t find( const WatchTask* v_pWatchTask ) const;

	/*!
	 * w肵CfbNX̃^XN܂B
	 * XbhAoCh܂B
	 * \param CfbNX
	 */
	size_t erase( size_t idx );

	/*!
	 * w肵CfbNX̃^XN擾܂B
	 * \param idx CfbNX
	 * \return ^XN
	 */
	const TaskSettingInfo& operator[]( size_t idx ) const;

	size_t size() const;

	/*!
	 * ĎXbhŌɓǂݍ܂ĂύXĂ邩擾܂B
	 * \return ύXĂꍇtrueAłȂfalse
	 */
	bool isModified() const;

	/*!
	 * XbhO[vvt@C̎擾
	 */
	const ThreadGroupProfile& getThreadGroupProfile() const;

	/*!
	 * XbhO[vvt@C̐ݒ
	 */
	void setThreadGroupProfile( const ThreadGroupProfile& v_profile );

protected:

	/*!
	 * ݒ肩^XN\z܂B
	 * \return ^XN
	 */
	WatchTask* createWatchTaskInternal( const TaskSettingInfo& v_settingInfo );

private:

	const bool dryrun_;
	mutable bool modified_;

	BasicMultiTaskEx multiTask_;

	typedef std::vector<WatchTask*> WatchTaskList;
	WatchTaskList taskList_;
};

#endif
