#ifndef INCLUDE_H_SETTINGINFOFACTORY
#define INCLUDE_H_SETTINGINFOFACTORY

#include "SettingInfo.hpp"
#include "tstringUty.hpp"

#include <stdexcept>

#pragma warning( push )
#pragma warning( disable : 4290 )

class ActionSettingInfoFactory
{
public:
	ActionSettingInfoFactory() throw();

	ActionSettingInfoFactory( const ActionSettingInfo& v_settingInfo ) throw();

	ActionSettingInfoFactory( const ActionSettingInfoFactory& v_other ) throw();
	
	ActionSettingInfoFactory& operator=( const ActionSettingInfoFactory& v_other) throw();

	~ActionSettingInfoFactory() throw();

	void setAction( const tstring& v_action ) throw();

	void setAppName( const tstring& v_appName ) throw();

	void setParam( const tstring& v_param ) throw();

	void setMaxProcess( const unsigned int v_nMaxProcess ) throw();

	void setShowWindow( const ShowWindowType& v_nShowWindow ) throw();

	void setAppCurrentDir( const tstring& v_appCurrentDir ) throw();

	bool validate() const throw();

	const ActionSettingInfo& create() const;

private:

	ActionSettingInfo settingInfo_;

};


class CSettingInfoFactory {
public:

	class ErrorInfoListener {
	public:
		virtual ~ErrorInfoListener()  throw() {}
		virtual bool notifyErrorInfo( const tstring& v_errorInfo ) throw() = 0;
	};

	class CSettingInfoFactoryException : public std::runtime_error {
	public:
		CSettingInfoFactoryException( const tstring& v_message )
			: std::runtime_error( tstringuty::getStdString( v_message ) )
		{
		}
	};

	CSettingInfoFactory() throw();

	CSettingInfoFactory( const CSettingInfoFactory& v_other ) throw();

	CSettingInfoFactory& operator=( const CSettingInfoFactory& v_other ) throw();

	CSettingInfoFactory( const TaskSettingInfo& v_serringInfo ) throw();

	virtual ~CSettingInfoFactory() throw();

	void setErrorInfoListener( ErrorInfoListener* v_pErrorInfoListener ) throw();

	void setWatchDir( const tstring& v_watchDir ) throw();

	void setWatchFile( const tstring& v_watchFile ) throw();

	void setPersistentFile( const tstring& v_persistentFile ) throw();

	void setPersistenceDelaySpan( const CFileTimeSpan& v_persistenceDelaySpan ) throw();

	void setAction( const tstring& v_action ) throw();

	void setAppName( const tstring& v_appName ) throw();

	void setParam( const tstring& v_param ) throw();

	void setLog( const tstring& v_log ) throw();

	void setWaitWrite( const CFileTimeSpan& v_waitWrite ) throw();

	void setMaxProcess( const unsigned int v_nMaxProcess ) throw();

	void setShowWindow( const ShowWindowType& v_nShowWindow ) throw();

	void setTolerance( const CFileTimeSpan& v_nTolerance ) throw();

	void setDeletePending( const CFileTimeSpan& v_nDeletePending ) throw();

	void setMaxDepth( const int v_maxDepth ) throw();

	void setForceInterval( const CFileTimeSpan& v_forceInterval ) throw();

	void setUsingDirNotificationAPI( const bool v_usingDirNotificationAPI ) throw();

	void setDirNotificationAPIRetryInterval( const CFileTimeSpan& v_dirNotificationAPIRetryInterval ) throw();

	void setDirNotificationAPIExpirySpan( const CFileTimeSpan& v_dirNotificationAPIExpirySpan ) throw();

	void setDelaySignalSpan( const CFileTimeSpan& v_delaySignalSpan ) throw();

	void setAppCurrentDir( const tstring& v_appCurrentDir ) throw();

	bool validate( const bool v_silent = true ) const throw();

	TaskSettingInfo create() const throw( CSettingInfoFactoryException );

protected:

	bool notifyErrorInfo( const tstring& v_errorInfo ) const throw();

private:

	ErrorInfoListener* pErrorInfoListener_;

	TaskSettingInfo info_;
};

#pragma warning( pop )
#endif
