#include "stdafx.hpp"

#include "EventDispatcher.hpp"

#include <assert.h>

EventDispatcher::EventDispatcher( const tstring& v_description )
	: description_( v_description )
{
}

EventDispatcher::~EventDispatcher() throw()
{
	for( EventListenerMap::iterator ite = eventListeners_.begin();
		ite != eventListeners_.end();
		++ite )
	{
		if( ite->second ) {
			EventListener* pEventListener = ite->first;
			delete pEventListener;
		}
	}
	eventListeners_.clear();
}

void EventDispatcher::tickEventCycle() throw()
{
	for( EventListenerMap::iterator ite_eventListeners = eventListeners_.begin();
		ite_eventListeners != eventListeners_.end();
		++ite_eventListeners
		)
	{
		EventListener* pEventListener = ite_eventListeners->first;
		assert( pEventListener != NULL );
		pEventListener->tickEventCycle();
	}
}

void EventDispatcher::notifyFileEvent( EventListener::EventType v_eventId, const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw()
{
	for( EventListenerMap::iterator ite_eventListeners = eventListeners_.begin();
		ite_eventListeners != eventListeners_.end();
		++ite_eventListeners
		)
	{
		EventListener* pEventListener = ite_eventListeners->first;
		assert( pEventListener != NULL );
		pEventListener->notifyFileEvent( v_eventId, v_absolutePath, v_fileInfo );
	}
}

void EventDispatcher::notifyStateEvent( EventListener::StateEventType v_eventId ) throw()
{
	for( EventListenerMap::iterator ite_eventListeners = eventListeners_.begin();
		ite_eventListeners != eventListeners_.end();
		++ite_eventListeners
		)
	{
		EventListener* pEventListener = ite_eventListeners->first;
		assert( pEventListener != NULL );
		pEventListener->notifyStateEvent( v_eventId );
	}
}

void EventDispatcher::appendEventListener( EventListener* v_pEventListener, bool v_autoRemove ) throw()
{
	//required:
	assert( v_pEventListener != NULL && "v_pEventListenerNULL͎wł܂B" );
	//do:
	if( v_pEventListener != NULL ) {
		eventListeners_.insert( EventListenerMap::value_type( v_pEventListener, v_autoRemove) );
	}
}

void EventDispatcher::removeEventListener( EventListener* v_pEventListener ) throw()
{
	//required:
	assert( v_pEventListener != NULL && "v_pEventListenerNULL͎wł܂B" );
	//do:
	if( v_pEventListener != NULL ) {
		EventListenerMap::iterator ite = eventListeners_.find( v_pEventListener );
		if( ite != eventListeners_.end() ) {
			if( ite->second ) {
				delete v_pEventListener;
			}
			eventListeners_.erase( ite );
		}
	}
}

tstring EventDispatcher::getDescription() const throw()
{
	return description_;
}

const EventDispatcher::EventListenerMap& EventDispatcher::eventListeners() const throw()
{
	return eventListeners_;
}

