#ifndef INCLUDE_H_ACTIONINVOKER
#define INCLUDE_H_ACTIONINVOKER

#include "FileInfo.hpp"
#include "SettingInfo.hpp"

#include "tstring.hpp"
#include <list>
#include <memory>

/*!
 * ANVsNXC^[tFCX
 */
class ActionInvoker {
public:
	/*!
	 * zfXgN^
	 */
	virtual ~ActionInvoker() throw() {}

	/*!
	 * ANVsvZXNB
	 * vZXɂ͑ΏۂƂȂt@Cւ̃tpXƁAt@Cp[^Ƃēn܂B
	 * \param v_absolutePath t@Cւ̃tpX
	 * \param v_fileInfo t@C
	 * \return vZXNłtrueAłȂfalse
	 */
	virtual bool createProcess( const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw() = 0;

	/*!
	 * ̃ANVɂċNꂽvZXŏÎ̃vZXnhN[ibv܂B
	 * ݎs̃vZX߂lƂ܂B
	 * \return ݎs̃vZX
	 */
	virtual unsigned int sweepTerminatedProcess() throw() = 0;

	/*!
	 * ̃ANV`ݒ擾܂B
	 */
	virtual const ActionSettingInfo& getSettingInfo() const throw() = 0;

	/*!
	 * ̃ANV̕\L擾܂B
	 */
	virtual tstring getDescription() const throw() = 0;

};

/*!
 * ActionInvokerauto_ptrGCAX
 */
typedef std::auto_ptr<ActionInvoker> ActionInvokerPtr;

/*!
 * ActionInvoker̃t@Ng
 */
class ActionInvokerFactory {
private:
	ActionInvokerFactory( const ActionInvokerFactory& ); //<! Ȃ
	operator=( const ActionInvokerFactory& ); //<! Ȃ

public:
	ActionInvokerFactory();
	virtual ~ActionInvokerFactory();
	virtual ActionInvokerPtr create( const ActionSettingInfo& v_actionSettingInfo ) const;
};


/*!
 * vZXNActionInvoker̒ۊ
 */
class AbstractActionInvoker : public virtual ActionInvoker
{
private:
	AbstractActionInvoker( const AbstractActionInvoker& ); //<! Ȃ
	operator=( const AbstractActionInvoker& ); //<! Ȃ

public:
	AbstractActionInvoker( const ActionSettingInfo& v_actionSettingInfo ) throw();
	virtual ~AbstractActionInvoker() = 0;

	virtual unsigned int sweepTerminatedProcess() throw();

	virtual const ActionSettingInfo& getSettingInfo() const throw();

protected:

	void addTraceProcessHandle( HANDLE v_hProcess ) throw();

	const ActionSettingInfo actionSettingInfo_;

private:

	typedef std::list<HANDLE> ProcessHandleList;

	ProcessHandleList processHandleList_;
};

/*!
 * vZX̋NShellExecutepActionInvoker̎
 */
class ShellExecActionInvoker : public AbstractActionInvoker {
private:
	ShellExecActionInvoker( const ShellExecActionInvoker& ); //<! Ȃ
	operator=( const ShellExecActionInvoker& ); //<! Ȃ

public:
	ShellExecActionInvoker( const ActionSettingInfo& v_actionSettingInfo ) throw();

	virtual ~ShellExecActionInvoker() throw();

	virtual bool createProcess( const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw();

	virtual tstring getDescription() const throw();

};

#endif
