#include "stdafx.hpp"

#include <assert.h>

#include "..\FWatch\PatternMatch.hpp"

void testPatternMatch()
{
	PatternMatchCollection patterns1( true ); // ׂă}b`OK
	assert( patterns1.isMatch( _TEXT("any") ) );
	
	patterns1.addPattern( SimplePatternMatch( _TEXT("*.txt") ) );
	assert( patterns1.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.dat") ) );

	patterns1.addPattern( SimplePatternMatch( _TEXT("*123.txt") ) );
	assert( patterns1.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.dat") ) );

	patterns1.addPattern( SimplePatternMatch( _TEXT("*123.dat") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.dat") ) );

	PatternMatchCollection patterns2( false ); // 1ł}b`OK
	assert( ! patterns2.isMatch( _TEXT("any") ) );
	
	patterns2.addPattern( SimplePatternMatch( _TEXT("*.txt") ) );
	assert( patterns2.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns2.isMatch( _TEXT("abc123.dat") ) );

	patterns2.addPattern( SimplePatternMatch( _TEXT("*123.dat") ) );
	assert( patterns2.isMatch( _TEXT("abc123.txt") ) );
	assert( patterns2.isMatch( _TEXT("abc123.dat") ) );

}
