#ifndef INCLUDE_H_PASSIVETIMER
#define INCLUDE_H_PASSIVETIMER

#include <atltime.h>

class PassiveTimer {
public:
	PassiveTimer( const CFileTimeSpan& v_span, const CFileTime& v_initialStartTime, const bool v_enabled );
	~PassiveTimer();
	bool isSignaled( const CFileTime& v_now ) const;
	void reset( const CFileTime& v_startTime, const bool v_enabled = true );
	const CFileTimeSpan& getSpan() const;
	bool isEnabled() const;
private:
	bool enabled_;
	const CFileTimeSpan span_;
	CFileTime startTime_;
};

#endif
