#include "stdafx.hpp"

#include "..\FWatch\SplitPath.hpp"

#include <assert.h>

void testSplitPath()
{
	SplitPath splitPath;

	assert( splitPath.getPath().empty() );
	assert( splitPath.getDirectory().empty() );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setPath( _TEXT("abc") );
	assert( splitPath.getPath() == _TEXT("abc") );
	assert( splitPath.getDirectory().empty() );
	assert( splitPath.getFile() == _TEXT("abc") );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension() == _TEXT("abc") );

	splitPath.setPath( _TEXT("C:\\abc\\") );
	assert( splitPath.getPath() == _TEXT("C:\\abc\\") );
	assert( splitPath.getDirectory() == _TEXT("C:\\abc\\") );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setPath( _TEXT("\\\\HOST\\abc\\") );
	assert( splitPath.getPath() == _TEXT("\\\\HOST\\abc\\") );
	assert( splitPath.getDirectory() == _TEXT("\\\\HOST\\abc\\") );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setDirectory( _TEXT("D:\\xyz") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setFile( _TEXT("test") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\test") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile() == _TEXT("test") );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension() == _TEXT("test") );

	splitPath.setFile( _TEXT("test2.") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\test2") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile() == _TEXT("test2") );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension() == _TEXT("test2") );

	splitPath.setFile( _TEXT("test3.txt") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\test3.txt") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile() == _TEXT("test3.txt") );
	assert( splitPath.getFileExtension() == _TEXT("txt") );
	assert( splitPath.getFileNoExtension() == _TEXT("test3") );

	splitPath.setPath( _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test4.dat") );
	assert( splitPath.getPath() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test4.dat") );
	assert( splitPath.getDirectory() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test4.dat") );
	assert( splitPath.getFileExtension() == _TEXT("dat") );
	assert( splitPath.getFileNoExtension() == _TEXT("test4") );

	splitPath.setPath( _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test5.dat.txt") );
	assert( splitPath.getPath() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test5.dat.txt") );
	assert( splitPath.getDirectory() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test5.dat.txt") );
	assert( splitPath.getFileExtension() == _TEXT("txt") );
	assert( splitPath.getFileNoExtension() == _TEXT("test5.dat") );

	splitPath.setPath( _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\test6.dat.txt") );
	assert( splitPath.getPath() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\test6.dat.txt") );
	assert( splitPath.getDirectory() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test6.dat.txt") );
	assert( splitPath.getFileExtension() == _TEXT("txt") );
	assert( splitPath.getFileNoExtension() == _TEXT("test6.dat") );

	splitPath.setFileExtension( _TEXT("hlp") );
	assert( splitPath.getPath() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\test6.dat.hlp") );
	assert( splitPath.getDirectory() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test6.dat.hlp") );
	assert( splitPath.getFileExtension() == _TEXT("hlp") );
	assert( splitPath.getFileNoExtension() == _TEXT("test6.dat") );

}
